/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.gfse.contents;

import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.pd.gfse.contents.GFSEContentItem;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.selayer.SEGroupedContent;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFRoleMapHelper;

public abstract class GFSEGroupedContent
extends GFSEContentItem
implements SEGroupedContent {
    protected final List<Operator> operators;
    protected final COSObject parentStructElem;
    protected final String parentsTags;
    protected final boolean isSignature;
    protected final String defaultLang;
    protected final Boolean isTaggedContent;

    public GFSEGroupedContent(String objectType, List<Operator> operators, COSObject parentStructElem, String parentsTags, String defaultLang, boolean isSignature) {
        super(objectType);
        this.operators = operators;
        this.parentStructElem = parentStructElem;
        this.parentsTags = parentsTags;
        this.defaultLang = defaultLang;
        this.isSignature = isSignature;
        this.isTaggedContent = this.isTaggedContent();
    }

    public String getparentsTags() {
        return this.parentsTags;
    }

    public String getparentStructureTag() {
        return this.parentStructElem != null ? this.parentStructElem.getNameKeyStringValue(ASAtom.S) : null;
    }

    public String getparentStandardTag() {
        TaggedPDFRoleMapHelper taggedPDFRoleMapHelper = StaticResources.getRoleMapHelper();
        if (this.parentStructElem != null && taggedPDFRoleMapHelper != null) {
            PDStructElem structElem = new PDStructElem(this.parentStructElem, taggedPDFRoleMapHelper.getRoleMap());
            return PDStructElem.getStructureElementStandardType((PDStructElem)structElem);
        }
        return null;
    }

    public Boolean getisSignature() {
        return this.isSignature;
    }

    public String getLangValue() {
        return this.defaultLang;
    }

    public Boolean getisArtifact() {
        return this.hasParentWithStandardType("Artifact");
    }

    protected Boolean hasParentWithStandardType(String standardType) {
        TaggedPDFRoleMapHelper taggedPDFRoleMapHelper = StaticResources.getRoleMapHelper();
        if (this.parentStructElem != null && taggedPDFRoleMapHelper != null) {
            for (PDStructElem structElem = new PDStructElem(this.parentStructElem, taggedPDFRoleMapHelper.getRoleMap()); structElem != null; structElem = structElem.getParent()) {
                if (!standardType.equals(PDStructElem.getStructureElementStandardType((PDStructElem)structElem))) continue;
                return true;
            }
        }
        return false;
    }

    public String getInheritedActualText() {
        return null;
    }

    public String getInheritedAlt() {
        return null;
    }

    public Long getMCID() {
        return null;
    }

    public String getActualText() {
        return null;
    }

    public String getAlt() {
        return null;
    }

    public Boolean getisTaggedContent() {
        return this.isTaggedContent;
    }

    private boolean isTaggedContent() {
        for (PDStructElem structElem = new PDStructElem(this.parentStructElem, null); structElem != null; structElem = structElem.getParent()) {
            if (structElem.getType() != ASAtom.STRUCT_TREE_ROOT) continue;
            return true;
        }
        return false;
    }

    public String getparentStructureElementObjectKey() {
        return this.parentStructElem.getObjectKey().toString();
    }
}

