/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.gfse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.operator.inlineimage.GFOp_EI;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOpMarkedContent;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOpPathPaint;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOp_n;
import org.verapdf.gf.model.impl.operator.shading.GFOp_sh;
import org.verapdf.gf.model.impl.operator.textshow.GFOpTextShow;
import org.verapdf.gf.model.impl.operator.xobject.GFOp_Do;
import org.verapdf.gf.model.impl.pd.gfse.GFSEContentItem;
import org.verapdf.gf.model.impl.pd.gfse.GFSEImageXObjectItem;
import org.verapdf.gf.model.impl.pd.gfse.GFSEInlineImageItem;
import org.verapdf.gf.model.impl.pd.gfse.GFSELineArtItem;
import org.verapdf.gf.model.impl.pd.gfse.GFSEShadingItem;
import org.verapdf.gf.model.impl.pd.gfse.GFSETextItem;
import org.verapdf.gf.model.impl.pd.images.GFPDXImage;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosName;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.pdlayer.PDXObject;
import org.verapdf.model.selayer.SEContentItem;
import org.verapdf.model.selayer.SEMarkedContent;

public class GFSEMarkedContent
extends GFSEContentItem
implements SEMarkedContent {
    public static final String MARKED_CONTENT_TYPE = "SEMarkedContent";
    public static final String LANG = "Lang";
    private final String defaultLang;
    private final GFOpMarkedContent operator;

    public GFSEMarkedContent(List<Operator> operators, COSObject parentStructElem, String parentsTags, String defaultLang) {
        this(operators, null, parentStructElem, parentsTags, defaultLang);
    }

    public GFSEMarkedContent(List<Operator> operators, GFOpMarkedContent parentMarkedContentOperator, COSObject parentStructElem, String parentsTags, String defaultLang) {
        super(MARKED_CONTENT_TYPE, parentMarkedContentOperator, parentStructElem, parentsTags);
        this.operators = operators.subList(1, operators.size() - 1);
        this.operator = (GFOpMarkedContent)operators.get(0);
        this.defaultLang = defaultLang;
        COSObject structElem = this.operator.getParentStructElem();
        if (structElem != null) {
            this.parentStructElem = structElem;
        }
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "contentItem": {
                return this.getContentItem();
            }
            case "Lang": {
                return this.getLang();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<SEContentItem> getContentItem() {
        if (this.operators == null) {
            return Collections.emptyList();
        }
        Stack<Integer> markedContentStack = new Stack<Integer>();
        ArrayList<GFSEContentItem> list = new ArrayList<GFSEContentItem>();
        for (int i = 0; i < this.operators.size(); ++i) {
            List<PDXObject> xObjects;
            Operator op = (Operator)this.operators.get(i);
            String type = op.getObjectType();
            if ("Op_BDC".equals(type) || "Op_BMC".equals(type)) {
                markedContentStack.push(i);
            } else if ("Op_EMC".equals(type) && !markedContentStack.empty()) {
                int markedContentIndex = (Integer)markedContentStack.pop();
                if (markedContentStack.empty()) {
                    list.add(new GFSEMarkedContent(this.operators.subList(markedContentIndex, i + 1), this.operator, this.parentStructElem, this.parentsTags, this.defaultLang));
                }
            }
            if (!markedContentStack.empty()) continue;
            if (op instanceof GFOpTextShow) {
                list.add(new GFSETextItem((GFOpTextShow)op, this.operator, this.parentStructElem, this.parentsTags, this.defaultLang));
                continue;
            }
            if (op instanceof GFOp_sh) {
                list.add(new GFSEShadingItem((GFOp_sh)op, this.operator, this.parentStructElem, this.parentsTags));
                continue;
            }
            if (op instanceof GFOpPathPaint && !(op instanceof GFOp_n)) {
                list.add(new GFSELineArtItem((GFOpPathPaint)op, this.operator, this.parentStructElem, this.parentsTags));
                continue;
            }
            if (op instanceof GFOp_EI) {
                list.add(new GFSEInlineImageItem((GFOp_EI)op, this.operator, this.parentStructElem, this.parentsTags));
                continue;
            }
            if (!(op instanceof GFOp_Do) || (xObjects = ((GFOp_Do)op).getXObject()) == null || xObjects.size() == 0 || !ASAtom.IMAGE.getValue().equals(xObjects.get(0).getSubtype())) continue;
            list.add(new GFSEImageXObjectItem((GFOp_Do)op, (GFPDXImage)xObjects.get(0), this.operator, this.parentStructElem, this.parentsTags));
        }
        return Collections.unmodifiableList(list);
    }

    public List<CosLang> getLang() {
        return this.operator.getLang();
    }

    public String getinheritedLang() {
        String inheritedLang = this.operator.getParentLang();
        return inheritedLang != null ? inheritedLang : this.defaultLang;
    }

    @Override
    public String getExtraContext() {
        Long mcid = this.operator.getMCID();
        return mcid != null ? "mcid:" + mcid : (this.parentMCID != null ? "mcid:" + this.parentMCID : null);
    }

    public String gettag() {
        List<CosName> tag = this.operator.getTag();
        if (tag != null && tag.size() != 0) {
            return tag.get(0).getinternalRepresentation();
        }
        return null;
    }

    public String getstructureTag() {
        return this.parentStructElem != null ? this.parentStructElem.getNameKeyStringValue(ASAtom.S) : null;
    }

    public String getE() {
        COSString E = this.operator.getE();
        return E != null ? E.toString() : null;
    }

    public String getAlt() {
        COSString Alt = this.operator.getAlt();
        return Alt != null ? Alt.toString() : null;
    }

    public String getActualText() {
        COSString ActualText = this.operator.getActualText();
        return ActualText != null ? ActualText.toString() : null;
    }
}

