/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.tools;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.xmp.impl.ByteBuffer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DictionaryKeysHelper {
    private static final Logger LOGGER = Logger.getLogger(DictionaryKeysHelper.class.getCanonicalName());

    public static String getStringOrStreamEntryStringRepresentation(COSObject dictionary, ASAtom key) {
        COSObject object = dictionary.getKey(key);
        if (object == null || object.empty()) {
            return null;
        }
        COSBase base = object.getDirectBase();
        if (base.getType() == COSObjType.COS_STREAM) {
            base = ((COSStream)base).getStringFromTextStream();
        }
        if (base.getType() == COSObjType.COS_STRING) {
            return base.getString();
        }
        return null;
    }

    public static String getRichTextStringOrStreamEntryStringRepresentation(COSObject dictionary, ASAtom key) {
        try {
            Object inputStream;
            COSObject object = dictionary.getKey(key);
            if (object == null || object.empty()) {
                return null;
            }
            COSBase base = object.getDirectBase();
            if (object.getType() == COSObjType.COS_STREAM) {
                inputStream = base.getData();
            } else if (object.getType() == COSObjType.COS_STRING) {
                inputStream = new ByteBuffer(object.getDirectBase().getString().getBytes()).getByteStream();
            } else {
                return null;
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(null);
            Document doc = builder.parse(new InputSource((InputStream)inputStream));
            return DictionaryKeysHelper.getAllNodeText(doc);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error while parsing rich text entry " + key + " in the object " + dictionary.getKey());
            return null;
        }
    }

    private static String getAllNodeText(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeValue() != null) {
                stringBuilder.append(child.getNodeValue());
                continue;
            }
            stringBuilder.append(DictionaryKeysHelper.getAllNodeText(child));
        }
        return stringBuilder.toString();
    }
}

