/*
 * This file is part of veraPDF XMP Library Core for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF XMP Library Core for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF XMP Library Core for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF XMP Library Core for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2006 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package org.verapdf.xmp.impl.xpath;


/**
 * A segment of a parsed <code>XMPPath</code>.
 *  
 * @since   23.06.2006
 */
public class XMPPathSegment
{
	/** name of the path segment */
	private String name;
	/** kind of the path segment */
	private int kind;
	/** flag if segment is an alias */
	private boolean alias;
	/** alias form if applicable */
	private int aliasForm;


	/**
	 * Constructor with initial values.
	 * 
	 * @param name the name of the segment
	 */
	public XMPPathSegment(String name)
	{
		this.name = name;
	}


	/**
	 * Constructor with initial values.
	 * 
	 * @param name the name of the segment
	 * @param kind the kind of the segment
	 */
	public XMPPathSegment(String name, int kind)
	{
		this.name = name;
		this.kind = kind;
	}


	/**
	 * @return Returns the kind.
	 */
	public int getKind()
	{
		return kind;
	}


	/**
	 * @param kind The kind to set.
	 */
	public void setKind(int kind)
	{
		this.kind = kind;
	}


	/**
	 * @return Returns the name.
	 */
	public String getName()
	{
		return name;
	}


	/**
	 * @param name The name to set.
	 */
	public void setName(String name)
	{
		this.name = name;
	}


	/**
	 * @param alias the flag to set
	 */
	public void setAlias(boolean alias)
	{
		this.alias = alias;
	}


	/**
	 * @return Returns the alias.
	 */
	public boolean isAlias()
	{
		return alias;
	}
	
	
	/** 
	 * @return Returns the aliasForm if this segment has been created by an alias.
	 */ 
	public int getAliasForm()
	{
		return aliasForm;
	}

	
	/**
	 * @param aliasForm the aliasForm to set
	 */
	public void setAliasForm(int aliasForm)
	{
		this.aliasForm = aliasForm;
	}
	
	
	/**
	 * @see Object#toString()
	 */
	public String toString()
	{
		switch (kind)
		{
			case XMPPath.STRUCT_FIELD_STEP:
			case XMPPath.ARRAY_INDEX_STEP: 
			case XMPPath.QUALIFIER_STEP: 
			case XMPPath.ARRAY_LAST_STEP: 
				return name;
			case XMPPath.QUAL_SELECTOR_STEP: 
			case XMPPath.FIELD_SELECTOR_STEP: 
			return name;

		default:
			// no defined step
			return name;
		}
	}
}
