/*
 * This file is part of veraPDF XMP Library Core for Jakarta EE, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF XMP Library Core for Jakarta EE is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF XMP Library Core for Jakarta EE as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF XMP Library Core for Jakarta EE as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2006 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package org.verapdf.xmp;

/**
 * This exception wraps all errors that occur in the XMP Toolkit.
 * 
 * @since   16.02.2006
 */
public class XMPException extends Exception
{
	/** the errorCode of the XMP toolkit */
	private int errorCode;


	/**
	 * Constructs an exception with a message and an error code. 
	 * @param message the message
	 * @param errorCode the error code
	 */
	public XMPException(String message, int errorCode)
	{
		super(message);
		this.errorCode = errorCode;
	}


	/**
	 * Constructs an exception with a message, an error code and a <code>Throwable</code>
	 * @param message the error message.
	 * @param errorCode the error code
	 * @param t the exception source
	 */
	public XMPException(String message, int errorCode, Throwable t)
	{
		super(message, t);
		this.errorCode = errorCode;
	}


	/**
	 * @return Returns the errorCode.
	 */
	public int getErrorCode()
	{
		return errorCode;
	}
}