/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.lists;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.lists.ListItem;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.entities.tables.TableTokenRow;

public class PDFList
extends InfoChunk {
    private final List<ListItem> listItems;

    public PDFList(Table table) {
        super(table.getBoundingBox());
        this.setRecognizedStructureId(table.getId());
        this.listItems = new ArrayList<ListItem>();
        this.createListItemsFromTableRows(table.getRows());
    }

    public PDFList(Long id) {
        this.setRecognizedStructureId(id);
        this.listItems = new ArrayList<ListItem>();
    }

    public int getNumberOfListItems() {
        return this.listItems.size();
    }

    public List<ListItem> getListItems() {
        return this.listItems;
    }

    public void add(ListItem listItem) {
        this.listItems.add(listItem);
        this.getBoundingBox().union(listItem.getBoundingBox());
    }

    public void add(int index, ListItem listItem) {
        this.listItems.add(index, listItem);
        this.getBoundingBox().union(listItem.getBoundingBox());
    }

    private void createListItemsFromTableRows(List<TableRow> tableRows) {
        ListItem lastListItem = null;
        for (TableRow row : tableRows) {
            TableCell firstCell = row.getCells().get(0);
            if (firstCell.getString().trim().isEmpty() && (firstCell.getContent().isEmpty() || firstCell.getContent().get(0).getType() == TableToken.TableTokenType.TEXT) && lastListItem != null) {
                if (firstCell.getContent().isEmpty() && lastListItem.getLabel().getRightX() > row.getCells().get(1).getLeftX()) {
                    return;
                }
                lastListItem.add(row);
                continue;
            }
            TableCell secondCell = row.getCells().get(1);
            if (lastListItem != null && firstCell.getBoundingBox().getTopY() < secondCell.getBoundingBox().getTopY()) {
                for (TableTokenRow tokenRow : secondCell.getContent()) {
                    if (!(tokenRow.getBoundingBox().getBottomY() > firstCell.getBoundingBox().getTopY())) break;
                    lastListItem.getBody().add(tokenRow);
                }
                secondCell.getContent().removeAll(lastListItem.getBody().getContent());
            }
            lastListItem = new ListItem(row);
            this.add(lastListItem);
        }
    }
}

