/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities;

import java.util.List;
import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

public class SemanticParagraph
extends SemanticTextNode {
    protected boolean enclosedTop;
    protected boolean enclosedBottom;
    protected int indentation;

    public SemanticParagraph(SemanticParagraph paragraph) {
        super(paragraph);
        this.enclosedBottom = paragraph.enclosedBottom;
        this.enclosedTop = paragraph.enclosedTop;
        this.indentation = paragraph.indentation;
    }

    public SemanticParagraph() {
        this.setSemanticType(SemanticType.PARAGRAPH);
    }

    public SemanticParagraph(SemanticType initialSemanticType) {
        super(initialSemanticType);
        this.setSemanticType(SemanticType.PARAGRAPH);
    }

    public SemanticParagraph(BoundingBox bbox, List<TextColumn> columns) {
        super(bbox, columns);
        this.setSemanticType(SemanticType.PARAGRAPH);
    }

    public SemanticParagraph(BoundingBox bbox) {
        super(bbox);
        this.setSemanticType(SemanticType.PARAGRAPH);
    }

    public SemanticParagraph(SemanticTextNode textNode) {
        super(textNode);
        this.setSemanticType(SemanticType.PARAGRAPH);
    }

    public boolean isEnclosedTop() {
        return this.enclosedTop;
    }

    public void setEnclosedTop(boolean enclosedTop) {
        this.enclosedTop = enclosedTop;
    }

    public boolean isEnclosedBottom() {
        return this.enclosedBottom;
    }

    public void setEnclosedBottom(boolean enclosedBottom) {
        this.enclosedBottom = enclosedBottom;
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) {
        this.indentation = indentation;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SemanticParagraph)) {
            return false;
        }
        SemanticParagraph that = (SemanticParagraph)o;
        return this.enclosedTop == that.enclosedTop && this.enclosedBottom == that.enclosedBottom && this.indentation == that.indentation;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.enclosedTop, this.enclosedBottom, this.indentation);
        return result;
    }
}

