/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.geometry;

import java.util.LinkedList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

public class MultiBoundingBox
extends BoundingBox {
    private List<BoundingBox> boundingBoxes = new LinkedList<BoundingBox>();

    public MultiBoundingBox() {
        this.init(Double.MAX_VALUE, Double.MAX_VALUE, 0.0, 0.0);
        this.boundingBoxes.add(new BoundingBox());
    }

    public MultiBoundingBox(int pageNumber) {
        this.init(Double.MAX_VALUE, Double.MAX_VALUE, 0.0, 0.0);
        this.pageNumber = this.lastPageNumber = Integer.valueOf(pageNumber);
        this.boundingBoxes.add(new BoundingBox(pageNumber));
    }

    public MultiBoundingBox(double[] bbox) {
        this.init(bbox[0], bbox[1], bbox[2], bbox[3]);
        this.boundingBoxes.add(new BoundingBox(bbox));
    }

    public MultiBoundingBox(int pageNumber, double[] bbox) {
        this.init(bbox[0], bbox[1], bbox[2], bbox[3]);
        this.pageNumber = this.lastPageNumber = Integer.valueOf(pageNumber);
        this.boundingBoxes.add(new BoundingBox(pageNumber, bbox));
    }

    public MultiBoundingBox(int pageNumber, int lastPageNumber, double[] bbox) {
        this.init(bbox[0], bbox[1], bbox[2], bbox[3]);
        this.pageNumber = pageNumber;
        this.lastPageNumber = lastPageNumber;
        this.boundingBoxes.add(new BoundingBox(pageNumber, lastPageNumber, bbox));
    }

    public MultiBoundingBox(double left, double bottom, double right, double top) {
        this.init(left, bottom, right, top);
        this.boundingBoxes.add(new BoundingBox(left, bottom, right, top));
    }

    public MultiBoundingBox(int pageNumber, double left, double bottom, double right, double top) {
        this.init(left, bottom, right, top);
        this.pageNumber = this.lastPageNumber = Integer.valueOf(pageNumber);
        this.boundingBoxes.add(new BoundingBox(pageNumber, left, bottom, right, top));
    }

    public MultiBoundingBox(int pageNumber, int lastPageNumber, double left, double bottom, double right, double top) {
        this.init(left, bottom, right, top);
        this.pageNumber = pageNumber;
        this.lastPageNumber = lastPageNumber;
        this.boundingBoxes.add(new BoundingBox(pageNumber, lastPageNumber, left, bottom, right, top));
    }

    public MultiBoundingBox(BoundingBox o) {
        this.init(o);
    }

    public static MultiBoundingBox union(BoundingBox first, BoundingBox second) {
        MultiBoundingBox result = new MultiBoundingBox(first);
        return result.union(second);
    }

    @Override
    public MultiBoundingBox union(BoundingBox second) {
        if (second == null || second.getPageNumber() == null) {
            return this;
        }
        if (this.pageNumber == null) {
            this.init(second);
            return this;
        }
        if (second instanceof MultiBoundingBox) {
            this.boundingBoxes.addAll(((MultiBoundingBox)second).boundingBoxes);
        } else {
            this.boundingBoxes.add(new BoundingBox(second));
        }
        if (second.leftX < this.leftX) {
            this.leftX = second.leftX;
        }
        if (this.rightX < second.rightX) {
            this.rightX = second.rightX;
        }
        if (this.pageNumber.equals(second.pageNumber)) {
            this.topY = Math.max(this.topY, second.topY);
        } else if (second.pageNumber < this.pageNumber) {
            this.topY = second.topY;
            this.pageNumber = second.pageNumber;
        }
        if (this.lastPageNumber.equals(second.lastPageNumber)) {
            this.bottomY = Math.min(this.bottomY, second.bottomY);
        } else if (this.lastPageNumber < second.lastPageNumber) {
            this.bottomY = second.bottomY;
            this.lastPageNumber = second.lastPageNumber;
        }
        return this;
    }

    @Override
    public BoundingBox scale(double coeffX, double coeffY) {
        for (BoundingBox boundingBox : this.boundingBoxes) {
            boundingBox.scale(coeffX, coeffY);
        }
        return super.scale(coeffX, coeffY);
    }

    @Override
    public BoundingBox move(double xShift, double yShift) {
        for (BoundingBox boundingBox : this.boundingBoxes) {
            boundingBox.move(xShift, yShift);
        }
        return super.move(xShift, yShift);
    }

    @Override
    public void init(BoundingBox rect) {
        super.init(rect);
        this.boundingBoxes = new LinkedList<BoundingBox>();
        if (rect instanceof MultiBoundingBox) {
            this.boundingBoxes.addAll(((MultiBoundingBox)rect).boundingBoxes);
        } else {
            this.boundingBoxes.add(new BoundingBox(rect));
        }
    }

    @Override
    public void init(double left, double bottom, double right, double top) {
        super.init(left, bottom, right, top);
        this.boundingBoxes = new LinkedList<BoundingBox>();
        this.boundingBoxes.add(new BoundingBox(this));
    }

    public List<BoundingBox> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    @Override
    public BoundingBox getBoundingBox(int pageNumber) {
        if (this.pageNumber > pageNumber || this.lastPageNumber < pageNumber) {
            return null;
        }
        if (this.pageNumber == pageNumber && this.lastPageNumber == pageNumber) {
            return this;
        }
        MultiBoundingBox boundingBox = new MultiBoundingBox();
        for (BoundingBox box : this.boundingBoxes) {
            if (box.getPageNumber() != pageNumber) continue;
            ((BoundingBox)boundingBox).union(box);
        }
        return boundingBox;
    }

    @Override
    public Double getRightX(int pageNumber) {
        if (this.pageNumber > pageNumber || this.lastPageNumber < pageNumber) {
            return null;
        }
        if (this.pageNumber == pageNumber && this.lastPageNumber == pageNumber) {
            return this.getRightX();
        }
        Double maxRight = null;
        for (BoundingBox box : this.boundingBoxes) {
            Double right = box.getRightX(pageNumber);
            if (maxRight != null && (right == null || !(maxRight < right))) continue;
            maxRight = right;
        }
        return maxRight;
    }

    @Override
    public Double getLeftX(int pageNumber) {
        if (this.pageNumber > pageNumber || this.lastPageNumber < pageNumber) {
            return null;
        }
        if (this.pageNumber == pageNumber && this.lastPageNumber == pageNumber) {
            return this.getLeftX();
        }
        Double minLeft = null;
        for (BoundingBox box : this.boundingBoxes) {
            Double left = box.getLeftX(pageNumber);
            if (minLeft != null && (left == null || !(minLeft > left))) continue;
            minLeft = left;
        }
        return minLeft;
    }
}

