/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms;

import org.verapdf.wcag.algorithms.entities.IDocument;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.tables.TableBordersCollection;
import org.verapdf.wcag.algorithms.semanticalgorithms.ISemanticsChecker;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.AccumulatedNodeConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ClusterTableConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ContrastRatioConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.HeadingCaptionConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.LinesPreprocessingConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ListDetectionConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.SemanticDocumentPostprocessingConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.SemanticDocumentPreprocessingConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.TOCDetectionConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.TableBorderConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.TableChecker;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.WCAGConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;

public class AccumulatedNodeSemanticChecker
implements ISemanticsChecker {
    @Override
    public void checkSemanticDocument(IDocument document, String fileName) {
        AccumulatedNodeConsumer semanticDetectionValidator;
        StaticContainers.updateContainers(document);
        ITree tree = document.getTree();
        if (tree == null) {
            return;
        }
        LinesPreprocessingConsumer linesPreprocessingConsumer = new LinesPreprocessingConsumer();
        if (!AccumulatedNodeSemanticChecker.startNextStep(linesPreprocessingConsumer)) {
            return;
        }
        linesPreprocessingConsumer.findTableBorders();
        StaticContainers.setTableBordersCollection(new TableBordersCollection(linesPreprocessingConsumer.getTableBorders()));
        SemanticDocumentPreprocessingConsumer semanticDocumentValidator = new SemanticDocumentPreprocessingConsumer();
        if (!AccumulatedNodeSemanticChecker.startNextStep(semanticDocumentValidator)) {
            return;
        }
        tree.forEach(semanticDocumentValidator);
        StaticContainers.setStructElementsNumber(semanticDocumentValidator.getStructElementsNumber());
        StaticContainers.setTextChunksNumber(semanticDocumentValidator.getTextChunksNumber());
        if (fileName != null) {
            ContrastRatioConsumer contrastRatioConsumer = new ContrastRatioConsumer(fileName);
            if (!AccumulatedNodeSemanticChecker.startNextStep(contrastRatioConsumer)) {
                return;
            }
            contrastRatioConsumer.calculateContrast(document.getTree());
        }
        if (!AccumulatedNodeSemanticChecker.startNextStep(semanticDetectionValidator = new AccumulatedNodeConsumer())) {
            return;
        }
        tree.forEach(semanticDetectionValidator);
        HeadingCaptionConsumer headingCaptionConsumer = new HeadingCaptionConsumer();
        if (!AccumulatedNodeSemanticChecker.startNextStep(headingCaptionConsumer)) {
            return;
        }
        tree.forEach(headingCaptionConsumer);
        TOCDetectionConsumer tocDetectionConsumer = new TOCDetectionConsumer();
        if (!AccumulatedNodeSemanticChecker.startNextStep(tocDetectionConsumer)) {
            return;
        }
        tree.forEach(tocDetectionConsumer);
        ListDetectionConsumer listDetectionConsumer = new ListDetectionConsumer();
        if (!AccumulatedNodeSemanticChecker.startNextStep(listDetectionConsumer)) {
            return;
        }
        tree.forEach(listDetectionConsumer);
        TableBorderConsumer tableBorderConsumer = new TableBorderConsumer();
        if (!AccumulatedNodeSemanticChecker.startNextStep(tableBorderConsumer)) {
            return;
        }
        tableBorderConsumer.recognizeTables(tree);
        TableChecker tableChecker = new TableChecker();
        if (!AccumulatedNodeSemanticChecker.startNextStep(tableChecker)) {
            return;
        }
        tree.forEach(tableChecker);
        ClusterTableConsumer tableFinder = new ClusterTableConsumer();
        if (!AccumulatedNodeSemanticChecker.startNextStep(tableFinder)) {
            return;
        }
        tableFinder.findTables(tree.getRoot());
        SemanticDocumentPostprocessingConsumer documentPostprocessingConsumer = new SemanticDocumentPostprocessingConsumer();
        if (!AccumulatedNodeSemanticChecker.startNextStep(documentPostprocessingConsumer)) {
            return;
        }
        documentPostprocessingConsumer.runPostprocessingChecks(tree);
        StaticContainers.getWCAGValidationInfo().setCurrentConsumer(null);
    }

    public static boolean startNextStep(WCAGConsumer consumer) {
        if (StaticContainers.getWCAGValidationInfo().getAbortProcessing().booleanValue()) {
            StaticContainers.getWCAGValidationInfo().setAbortProcessing(false);
            StaticContainers.getWCAGValidationInfo().setCurrentConsumer(null);
            return false;
        }
        StaticContainers.getWCAGValidationInfo().setCurrentConsumer(consumer);
        return true;
    }
}

