/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.maps;

import java.util.HashMap;
import java.util.Map;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;

public class AccumulatedNodeMapper {
    private final Map<INode, INode> nodeToAccumulatedNodeMap = new HashMap<INode, INode>();

    public INode get(INode node) {
        if (node == null) {
            return null;
        }
        if (!this.nodeToAccumulatedNodeMap.containsKey(node)) {
            return node;
        }
        return this.nodeToAccumulatedNodeMap.get(node);
    }

    public void put(INode node, INode accumulatedNode) {
        if (node == null) {
            return;
        }
        this.nodeToAccumulatedNodeMap.put(node, accumulatedNode);
    }

    public void updateNode(INode node, INode accumulatedNode, double correctSemanticScore, SemanticType semanticType) {
        if (accumulatedNode == null) {
            node.setCorrectSemanticScore(0.0);
            return;
        }
        node.setCorrectSemanticScore(correctSemanticScore);
        node.setSemanticType(semanticType);
        accumulatedNode.setCorrectSemanticScore(correctSemanticScore);
        this.put(node, accumulatedNode);
    }
}

