/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.geometry;

import java.util.Arrays;
import java.util.Objects;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ContextUtils;

public class BoundingBox {
    protected Integer pageNumber;
    protected Integer lastPageNumber;
    protected double leftX;
    protected double bottomY;
    protected double rightX;
    protected double topY;
    private static final double EPSILON = 1.0E-18;

    public BoundingBox() {
        this.init(Double.MAX_VALUE, Double.MAX_VALUE, 0.0, 0.0);
    }

    public BoundingBox(Integer pageNumber) {
        this.init(Double.MAX_VALUE, Double.MAX_VALUE, 0.0, 0.0);
        this.pageNumber = this.lastPageNumber = pageNumber;
    }

    public BoundingBox(double[] bbox) {
        this.init(bbox[0], bbox[1], bbox[2], bbox[3]);
    }

    public BoundingBox(Integer pageNumber, double[] bbox) {
        this.init(Math.min(bbox[0], bbox[2]), Math.min(bbox[1], bbox[3]), Math.max(bbox[0], bbox[2]), Math.max(bbox[1], bbox[3]));
        this.pageNumber = this.lastPageNumber = pageNumber;
    }

    public BoundingBox(Integer pageNumber, Integer lastPageNumber, double[] bbox) {
        this.init(bbox[0], bbox[1], bbox[2], bbox[3]);
        this.pageNumber = pageNumber;
        this.lastPageNumber = lastPageNumber;
    }

    public BoundingBox(double left, double bottom, double right, double top) {
        this.init(left, bottom, right, top);
    }

    public BoundingBox(Integer pageNumber, double left, double bottom, double right, double top) {
        this.init(left, bottom, right, top);
        this.pageNumber = this.lastPageNumber = pageNumber;
    }

    public BoundingBox(Integer pageNumber, Integer lastPageNumber, double left, double bottom, double right, double top) {
        this.init(left, bottom, right, top);
        this.pageNumber = pageNumber;
        this.lastPageNumber = lastPageNumber;
    }

    public BoundingBox(BoundingBox o) {
        this.init(o);
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        if (this.lastPageNumber == null || this.lastPageNumber < pageNumber) {
            this.lastPageNumber = pageNumber;
        }
    }

    public void setLastPageNumber(Integer lastPageNumber) {
        this.lastPageNumber = lastPageNumber;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getLastPageNumber() {
        return this.lastPageNumber;
    }

    public static BoundingBox union(BoundingBox first, BoundingBox second) {
        BoundingBox result = new BoundingBox(first);
        return result.union(second);
    }

    public BoundingBox union(BoundingBox second) {
        if (second == null || second.pageNumber == null) {
            return this;
        }
        if (this.pageNumber == null) {
            this.init(second);
            return this;
        }
        if (second.leftX < this.leftX) {
            this.leftX = second.leftX;
        }
        if (this.rightX < second.rightX) {
            this.rightX = second.rightX;
        }
        if (this.pageNumber.equals(second.pageNumber)) {
            this.topY = Math.max(this.topY, second.topY);
        } else if (second.pageNumber < this.pageNumber) {
            this.topY = second.topY;
            this.pageNumber = second.pageNumber;
        }
        if (this.lastPageNumber.equals(second.lastPageNumber)) {
            this.bottomY = Math.min(this.bottomY, second.bottomY);
        } else if (this.lastPageNumber < second.lastPageNumber) {
            this.bottomY = second.bottomY;
            this.lastPageNumber = second.lastPageNumber;
        }
        return this;
    }

    public BoundingBox normalize() {
        if (this.pageNumber.equals(this.lastPageNumber)) {
            return this.normalize(this.leftX, this.bottomY, this.rightX, this.topY);
        }
        return this.normalize(this.leftX, this.rightX);
    }

    public double getWidth() {
        return this.rightX > this.leftX ? this.rightX - this.leftX : 0.0;
    }

    public double getHeight() {
        return this.pageNumber != null && this.pageNumber.equals(this.lastPageNumber) && this.topY > this.bottomY ? this.topY - this.bottomY : 0.0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.leftX);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.bottomY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.rightX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.topY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Objects.hash(this.pageNumber, this.lastPageNumber);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundingBox that = (BoundingBox)o;
        if (!Objects.equals(this.pageNumber, that.pageNumber)) {
            return false;
        }
        if (!Objects.equals(this.lastPageNumber, that.lastPageNumber)) {
            return false;
        }
        if (Math.abs(that.leftX - this.leftX) > 1.0E-18) {
            return false;
        }
        if (Math.abs(that.bottomY - this.bottomY) > 1.0E-18) {
            return false;
        }
        if (Math.abs(that.rightX - this.rightX) > 1.0E-18) {
            return false;
        }
        return Math.abs(that.topY - this.topY) > 1.0E-18;
    }

    public boolean overlaps(BoundingBox other) {
        return this.overlaps(other, 1.0E-18);
    }

    public boolean overlaps(BoundingBox other, double eps) {
        if (this.pageNumber == null || other.pageNumber == null) {
            return false;
        }
        return !this.notOverlaps(other, eps);
    }

    public boolean notOverlaps(BoundingBox other) {
        return this.notOverlaps(other, 1.0E-18);
    }

    public boolean notOverlaps(BoundingBox other, double eps) {
        if (this.pageNumber == null || other.pageNumber == null) {
            return true;
        }
        return this.leftX > other.rightX + eps || this.rightX + eps < other.leftX || this.pageNumber > other.lastPageNumber || this.lastPageNumber < other.pageNumber || this.bottomY > other.topY + eps && this.lastPageNumber.equals(other.pageNumber) || this.topY + eps < other.bottomY && this.pageNumber.equals(other.lastPageNumber);
    }

    public boolean contains(BoundingBox other) {
        return this.contains(other, 1.0E-18, 1.0E-18);
    }

    public boolean contains(BoundingBox other, double horizontalOffset, double verticalOffset) {
        if (this.pageNumber == null || other.pageNumber == null) {
            return false;
        }
        return this.leftX < other.leftX + horizontalOffset && other.rightX < this.rightX + horizontalOffset && (this.pageNumber < other.pageNumber || this.pageNumber.equals(other.pageNumber) && other.topY < this.topY + verticalOffset) && (this.lastPageNumber > other.lastPageNumber || this.lastPageNumber.equals(other.lastPageNumber) && this.bottomY < other.bottomY + verticalOffset);
    }

    public boolean weaklyContains(BoundingBox fullRectangle) {
        if (this.pageNumber == null || fullRectangle.pageNumber == null) {
            return false;
        }
        if (this.pageNumber.equals(fullRectangle.pageNumber) && this.lastPageNumber.equals(fullRectangle.pageNumber) && this.pageNumber.equals(this.lastPageNumber)) {
            BoundingBox part = this.cross(fullRectangle);
            return part != null && part.getArea() >= fullRectangle.getArea() * 0.7;
        }
        return this.contains(fullRectangle);
    }

    public static BoundingBox cross(BoundingBox first, BoundingBox second) {
        BoundingBox result = new BoundingBox(first);
        return result.cross(second, 0.0, 0.0);
    }

    public BoundingBox cross(BoundingBox other) {
        return this.cross(other, 0.0, 0.0);
    }

    public static BoundingBox cross(BoundingBox first, BoundingBox second, double horizontalOffset, double verticalOffset) {
        BoundingBox result = new BoundingBox(first);
        return result.cross(second, horizontalOffset, verticalOffset);
    }

    public BoundingBox cross(BoundingBox other, double horizontalOffset, double verticalOffset) {
        if (this.notOverlaps(other)) {
            return null;
        }
        if (this.leftX < other.leftX - horizontalOffset) {
            this.leftX = other.leftX - horizontalOffset;
        }
        if (this.rightX > other.rightX + horizontalOffset) {
            this.rightX = other.rightX + horizontalOffset;
        }
        if (this.pageNumber < other.pageNumber) {
            this.pageNumber = other.pageNumber;
            this.topY = other.topY;
        } else if (this.pageNumber.equals(other.pageNumber) && other.topY + verticalOffset < this.topY) {
            this.topY = other.topY + verticalOffset;
        }
        if (this.lastPageNumber > other.lastPageNumber) {
            this.lastPageNumber = other.lastPageNumber;
            this.bottomY = other.bottomY;
        } else if (this.lastPageNumber.equals(other.lastPageNumber) && this.bottomY < other.bottomY - verticalOffset) {
            this.bottomY = other.bottomY - verticalOffset;
        }
        return this;
    }

    public double getArea() {
        return this.isEmpty() ? 0.0 : this.getWidth() * this.getHeight();
    }

    public double getBottomY() {
        return this.bottomY;
    }

    public double getTopY() {
        return this.topY;
    }

    public double getLeftX() {
        return this.leftX;
    }

    public double getRightX() {
        return this.rightX;
    }

    public void setBottomY(double bottomY) {
        this.bottomY = bottomY;
    }

    public void setTopY(double topY) {
        this.topY = topY;
    }

    public void setLeftX(double leftX) {
        this.leftX = leftX;
    }

    public void setRightX(double rightX) {
        this.rightX = rightX;
    }

    public double getCenterX() {
        return 0.5 * (this.leftX + this.rightX);
    }

    public double getCenterY() {
        return 0.5 * (this.topY + this.bottomY);
    }

    public Double getRightX(int pageNumber) {
        if (this.pageNumber <= pageNumber && this.lastPageNumber >= pageNumber) {
            return this.getRightX();
        }
        return null;
    }

    public Double getLeftX(int pageNumber) {
        if (this.pageNumber <= pageNumber && this.lastPageNumber >= pageNumber) {
            return this.getLeftX();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.pageNumber == null || this.leftX > this.rightX + 1.0E-18 || this.lastPageNumber < this.pageNumber || this.pageNumber.equals(this.lastPageNumber) && this.bottomY > this.topY + 1.0E-18;
    }

    public BoundingBox scale(double coeffX, double coeffY) {
        this.rightX = this.leftX + (this.rightX - this.leftX) * coeffX;
        if (this.pageNumber == null || this.pageNumber.equals(this.lastPageNumber)) {
            this.topY = this.bottomY + (this.topY - this.bottomY) * coeffY;
        }
        return this;
    }

    public BoundingBox move(double xShift, double yShift) {
        this.leftX += xShift;
        this.rightX += xShift;
        this.bottomY += yShift;
        this.topY += yShift;
        return this;
    }

    public void setSizes(double width, double height) {
        this.init(this.leftX, this.bottomY, this.leftX + width, this.bottomY + height);
    }

    public void init(BoundingBox rect) {
        this.init(rect.leftX, rect.bottomY, rect.rightX, rect.topY);
        this.pageNumber = rect.pageNumber;
        this.lastPageNumber = rect.lastPageNumber;
    }

    public BoundingBox getBoundingBox(int pageNumber) {
        if (this.pageNumber > pageNumber || this.lastPageNumber < pageNumber) {
            return null;
        }
        return this;
    }

    public boolean isOnePageBoundingBox() {
        return this.pageNumber != null && Objects.equals(this.pageNumber, this.lastPageNumber);
    }

    public boolean isSeveralPagesBoundingBox() {
        return this.pageNumber != null && !Objects.equals(this.pageNumber, this.lastPageNumber);
    }

    public void init(double left, double bottom, double right, double top) {
        this.leftX = left;
        this.bottomY = bottom;
        this.rightX = right;
        this.topY = top;
    }

    private BoundingBox normalize(double left, double bottom, double right, double top) {
        this.leftX = Math.min(left, right);
        this.rightX = Math.max(left, right);
        this.bottomY = Math.min(bottom, top);
        this.topY = Math.max(bottom, top);
        return this;
    }

    private BoundingBox normalize(double left, double right) {
        this.leftX = Math.min(left, right);
        this.rightX = Math.max(left, right);
        return this;
    }

    public String getLocation() {
        return ContextUtils.getContext(this);
    }

    public String toString() {
        return Arrays.toString(new double[]{this.leftX, this.bottomY, this.rightX, this.topY});
    }
}

