/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.lists.info;

import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemImageInfo;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemLineArtInfo;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemTextInfo;

public class ListItemInfo {
    private int index;
    private SemanticType semanticType;

    public ListItemInfo(ListItemInfo info) {
        this(info.getIndex(), info.getSemanticType());
    }

    public ListItemInfo(int index) {
        this.index = index;
    }

    protected ListItemInfo(int index, SemanticType semanticType) {
        this.index = index;
        this.semanticType = semanticType;
    }

    public int getIndex() {
        return this.index;
    }

    public static ListItemInfo createListItemInfo(ListItemInfo info) {
        if (info instanceof ListItemTextInfo) {
            return new ListItemTextInfo((ListItemTextInfo)info);
        }
        if (info instanceof ListItemLineArtInfo) {
            return new ListItemLineArtInfo((ListItemLineArtInfo)info);
        }
        if (info instanceof ListItemImageInfo) {
            return new ListItemImageInfo((ListItemImageInfo)info);
        }
        return new ListItemInfo(info);
    }

    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public InfoChunk getListItemValue() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListItemInfo that = (ListItemInfo)o;
        return this.index == that.index && this.semanticType == that.semanticType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.semanticType});
    }

    public String toString() {
        return "ListItemInfo{index=" + this.index + ", semanticType=" + (Object)((Object)this.semanticType) + '}';
    }
}

