/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables.tableBorders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.verapdf.wcag.algorithms.entities.BaseObject;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.SemanticFigure;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.Vertex;
import org.verapdf.wcag.algorithms.entities.tables.TableBorderBuilder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderRow;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.TableChecker;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public class TableBorder
extends BaseObject {
    public static final double TABLE_BORDER_EPSILON = 0.6;
    public static final double MIN_CELL_CONTENT_INTERSECTION_PERCENT = 0.6;
    private final List<Double> xCoordinates = new LinkedList<Double>();
    private final List<Double> xWidths = new LinkedList<Double>();
    private final List<Double> yCoordinates = new LinkedList<Double>();
    private final List<Double> yWidths = new LinkedList<Double>();
    private TableBorderRow[] rows;
    private int numberOfRows;
    private int numberOfColumns;
    private INode node;
    private boolean isBadTable = false;
    private TableBorder previousTable;
    private boolean isTableTransformer = false;
    private TableBorder nextTable;

    public TableBorder(TableBorderBuilder builder) {
        super(new BoundingBox(builder.getBoundingBox()));
        this.calculateXCoordinates(builder);
        this.calculateYCoordinates(builder);
        this.createMatrix(builder);
        this.setRecognizedStructureId(StaticContainers.getNextID());
    }

    public TableBorder(int numberOfRows, int numberOfColumns) {
        super(new BoundingBox());
        this.numberOfRows = numberOfRows;
        this.numberOfColumns = numberOfColumns;
        this.rows = new TableBorderRow[numberOfRows];
    }

    public TableBorder(BoundingBox boundingBox, TableBorderRow[] rows, int numberOfRows, int numberOfColumns) {
        super(boundingBox);
        this.rows = rows;
        this.numberOfRows = numberOfRows;
        this.numberOfColumns = numberOfColumns;
        this.calculateCoordinatesUsingBoundingBoxesOfRowsAndColumns();
        this.isTableTransformer = true;
        this.setRecognizedStructureId(StaticContainers.getNextID());
    }

    private void calculateXCoordinates(TableBorderBuilder builder) {
        List vertexes = builder.getVertexes().stream().sorted(new Vertex.VertexComparatorX()).collect(Collectors.toList());
        double x1 = ((Vertex)vertexes.get(0)).getLeftX();
        double x2 = ((Vertex)vertexes.get(0)).getRightX();
        for (Vertex v : vertexes) {
            if (x2 < v.getLeftX() - 4.0 * v.getRadius()) {
                this.xCoordinates.add(0.5 * (x1 + x2));
                this.xWidths.add(x2 - x1);
                x1 = v.getLeftX();
                x2 = v.getRightX();
                continue;
            }
            if (!(x2 < v.getRightX())) continue;
            x2 = v.getRightX();
        }
        this.xCoordinates.add(0.5 * (x1 + x2));
        this.xWidths.add(x2 - x1);
    }

    public TableBorder(INode tableNode) {
        super(new BoundingBox());
        int rowNumber;
        List<INode> tableRows = TableChecker.getTableRows(tableNode);
        this.numberOfRows = tableRows.size();
        if (this.numberOfRows == 0) {
            return;
        }
        this.numberOfColumns = TableChecker.getNumberOfColumns(tableRows.get(0));
        this.rows = new TableBorderRow[this.numberOfRows];
        for (int rowNumber2 = 0; rowNumber2 < this.numberOfRows; ++rowNumber2) {
            this.rows[rowNumber2] = new TableBorderRow(rowNumber2, this.numberOfColumns, null);
        }
        Integer pageNumber = null;
        for (rowNumber = 0; rowNumber < this.numberOfRows; ++rowNumber) {
            TableBorderRow row = this.rows[rowNumber];
            int columnNumber = 0;
            for (INode elem : tableRows.get(rowNumber).getChildren()) {
                SemanticType type = elem.getInitialSemanticType();
                if (SemanticType.TABLE_CELL != type && SemanticType.TABLE_HEADER != type) continue;
                while (columnNumber < this.numberOfColumns && row.getCells()[columnNumber] != null) {
                    ++columnNumber;
                }
                TableBorderCell cell = new TableBorderCell(elem, rowNumber, columnNumber);
                BoundingBox box = new BoundingBox();
                this.addContentToCell(cell, box, elem);
                cell.setBoundingBox(box);
                if (cell.getPageNumber() != null) {
                    if (pageNumber != null && !Objects.equals(pageNumber, cell.getPageNumber())) {
                        this.isBadTable = true;
                    }
                    pageNumber = cell.getPageNumber();
                }
                for (int i = 0; i < cell.getRowSpan(); ++i) {
                    for (int j = 0; j < cell.getColSpan(); ++j) {
                        this.rows[rowNumber + i].getCells()[columnNumber + j] = cell;
                    }
                }
                columnNumber += cell.getColSpan();
            }
        }
        this.calculateCoordinatesUsingBoundingBoxesOfRowsAndColumns();
        this.getBoundingBox().union(new BoundingBox(pageNumber, this.xCoordinates.get(0), this.yCoordinates.get(this.numberOfRows), this.xCoordinates.get(this.numberOfColumns), this.yCoordinates.get(0)));
        for (rowNumber = 0; rowNumber < this.numberOfRows; ++rowNumber) {
            MultiBoundingBox multiBoundingBox = new MultiBoundingBox();
            for (int colNumber = 0; colNumber < this.numberOfColumns; ++colNumber) {
                if (this.rows[rowNumber].cells[colNumber].colNumber != colNumber || this.rows[rowNumber].cells[colNumber].rowNumber != rowNumber) continue;
                ((BoundingBox)multiBoundingBox).union(this.rows[rowNumber].cells[colNumber].getBoundingBox());
            }
            multiBoundingBox.setLeftX(this.getLeftX());
            multiBoundingBox.setRightX(this.getRightX());
            this.rows[rowNumber].setBoundingBox(multiBoundingBox);
        }
        for (rowNumber = 0; rowNumber < this.getNumberOfRows(); ++rowNumber) {
            for (int columnNumber = 0; columnNumber < this.getNumberOfColumns(); ++columnNumber) {
                TableBorderCell cell = this.getCell(rowNumber, columnNumber);
                if (cell.getRowNumber() != rowNumber || cell.getColNumber() != columnNumber || cell.getBoundingBox().getPageNumber() != null) continue;
                BoundingBox boundingBox = new BoundingBox(this.getLeftX(columnNumber), this.getBottomY(rowNumber + cell.getRowSpan() - 1), this.getRightX(columnNumber + cell.getColSpan() - 1), this.getTopY(rowNumber));
                cell.setBoundingBox(boundingBox);
            }
        }
    }

    public TableBorderRow[] getRows() {
        return this.rows;
    }

    public TableBorderRow getRow(int rowNumber) {
        return this.rows[rowNumber];
    }

    public TableBorderCell getCell(int rowNumber, int columnNumber) {
        return this.getRow(rowNumber).getCell(columnNumber);
    }

    public int getNumberOfRowsWithContent() {
        int numberOfRowsWithContent = 0;
        for (TableBorderRow row : this.rows) {
            if (row.getNumberOfCellWithContent() <= 0) continue;
            ++numberOfRowsWithContent;
        }
        return numberOfRowsWithContent;
    }

    private void calculateYCoordinates(TableBorderBuilder builder) {
        List vertexes = builder.getVertexes().stream().sorted(new Vertex.VertexComparatorY()).collect(Collectors.toList());
        double y1 = ((Vertex)vertexes.get(0)).getTopY();
        double y2 = ((Vertex)vertexes.get(0)).getBottomY();
        for (Vertex v : vertexes) {
            if (y2 > v.getTopY() + 4.0 * v.getRadius()) {
                this.yCoordinates.add(0.5 * (y1 + y2));
                this.yWidths.add(y1 - y2);
                y1 = v.getTopY();
                y2 = v.getBottomY();
                continue;
            }
            if (!(y2 > v.getBottomY())) continue;
            y2 = v.getBottomY();
        }
        this.yCoordinates.add(0.5 * (y1 + y2));
        this.yWidths.add(y1 - y2);
    }

    private void createMatrix(TableBorderBuilder builder) {
        int numberOfRows = this.yCoordinates.size() - 1;
        int numberOfColumns = this.xCoordinates.size() - 1;
        if (numberOfColumns < 1 || numberOfRows < 1) {
            return;
        }
        TableBorderRow[] rows = new TableBorderRow[numberOfRows];
        for (int rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            rows[rowNumber] = new TableBorderRow(rowNumber, numberOfColumns, this.getRecognizedStructureId());
            for (int colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
                rows[rowNumber].cells[colNumber] = new TableBorderCell(rowNumber, colNumber, numberOfRows - rowNumber, numberOfColumns - colNumber, this.getRecognizedStructureId());
            }
        }
        boolean[] hasTopBorder = new boolean[numberOfColumns];
        boolean[] hasBottomBorder = new boolean[numberOfColumns];
        this.processHorizontalLines(rows, numberOfRows, builder, hasTopBorder, hasBottomBorder);
        boolean[] hasLeftBorder = new boolean[numberOfRows];
        boolean[] hasRightBorder = new boolean[numberOfRows];
        this.processVerticalLines(rows, numberOfColumns, builder, hasLeftBorder, hasRightBorder);
        if (this.processMergedCells(rows, numberOfRows, numberOfColumns)) {
            return;
        }
        for (int rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            MultiBoundingBox multiBoundingBox = new MultiBoundingBox();
            for (int colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
                if (rows[rowNumber].cells[colNumber].colNumber != colNumber || rows[rowNumber].cells[colNumber].rowNumber != rowNumber) continue;
                TableBorderCell cell = rows[rowNumber].cells[colNumber];
                BoundingBox cellBoundingBox = new BoundingBox(this.getBoundingBox().getPageNumber(), this.xCoordinates.get(colNumber), this.yCoordinates.get(rowNumber + cell.rowSpan), this.xCoordinates.get(colNumber + cell.colSpan), this.yCoordinates.get(rowNumber));
                cell.setBoundingBox(cellBoundingBox);
                ((BoundingBox)multiBoundingBox).union(cellBoundingBox);
            }
            rows[rowNumber].setBoundingBox(multiBoundingBox);
        }
        ArrayList<Integer> redundantRows = new ArrayList<Integer>(numberOfRows);
        ArrayList<Integer> usefulRows = new ArrayList<Integer>(numberOfRows);
        this.detectRedundantRows(redundantRows, usefulRows, rows, numberOfRows, numberOfColumns);
        ArrayList<Integer> redundantColumns = new ArrayList<Integer>(numberOfColumns);
        ArrayList<Integer> usefulColumns = new ArrayList<Integer>(numberOfColumns);
        this.detectRedundantColumns(redundantColumns, usefulColumns, rows, numberOfRows, numberOfColumns);
        if (redundantColumns.isEmpty() && redundantRows.isEmpty()) {
            this.rows = rows;
            this.numberOfRows = numberOfRows;
            this.numberOfColumns = numberOfColumns;
        } else {
            this.deleteRedundantRowsAndColumns(rows, numberOfRows, numberOfColumns, redundantRows, usefulRows, redundantColumns, usefulColumns);
        }
        this.checkBorders(hasTopBorder, hasBottomBorder, hasLeftBorder, hasRightBorder);
    }

    private void processHorizontalLines(TableBorderRow[] rows, int numberOfRows, TableBorderBuilder builder, boolean[] hasTopBorder, boolean[] hasBottomBorder) {
        for (LineChunk line : builder.getHorizontalLines()) {
            int colNumber;
            int rowNumber = this.getCoordinateY(line.getCenterY());
            int firstColNumber = this.getCoordinateX(line.getLeftX());
            int lastColNumber = this.getCoordinateX(line.getRightX());
            if (rowNumber == -1 || firstColNumber == -1 || lastColNumber == -1) continue;
            if (rowNumber > 0 && rowNumber < numberOfRows) {
                for (colNumber = firstColNumber; colNumber < lastColNumber; ++colNumber) {
                    rows[rowNumber - 1].cells[colNumber].rowSpan = 1;
                }
                continue;
            }
            if (rowNumber == 0) {
                for (colNumber = firstColNumber; colNumber < lastColNumber; ++colNumber) {
                    hasTopBorder[colNumber] = true;
                }
                continue;
            }
            if (rowNumber != numberOfRows) continue;
            for (colNumber = firstColNumber; colNumber < lastColNumber; ++colNumber) {
                hasBottomBorder[colNumber] = true;
            }
        }
    }

    private void processVerticalLines(TableBorderRow[] rows, int numberOfColumns, TableBorderBuilder builder, boolean[] hasLeftBorder, boolean[] hasRightBorder) {
        for (LineChunk line : builder.getVerticalLines()) {
            int rowNumber;
            int colNumber = this.getCoordinateX(line.getCenterX());
            int firstRowNumber = this.getCoordinateY(line.getTopY());
            int lastRowNumber = this.getCoordinateY(line.getBottomY());
            if (firstRowNumber == -1 || lastRowNumber == -1 || colNumber == -1) continue;
            if (colNumber > 0 && colNumber < numberOfColumns) {
                for (rowNumber = firstRowNumber; rowNumber < lastRowNumber; ++rowNumber) {
                    rows[rowNumber].cells[colNumber - 1].colSpan = 1;
                }
                continue;
            }
            if (colNumber == 0) {
                for (rowNumber = firstRowNumber; rowNumber < lastRowNumber; ++rowNumber) {
                    hasLeftBorder[rowNumber] = true;
                }
                continue;
            }
            if (colNumber != numberOfColumns) continue;
            for (rowNumber = firstRowNumber; rowNumber < lastRowNumber; ++rowNumber) {
                hasRightBorder[rowNumber] = true;
            }
        }
    }

    private boolean checkBorders(boolean[] hasTopBorder, boolean[] hasBottomBorder, boolean[] hasLeftBorder, boolean[] hasRightBorder) {
        if (!StaticContainers.isDataLoader() || this.numberOfRows == 1 || this.numberOfColumns == 1) {
            int i;
            for (i = 0; i < hasBottomBorder.length; ++i) {
                if (hasBottomBorder[i] && hasTopBorder[i]) continue;
                this.isBadTable = true;
                return this.isBadTable;
            }
            for (i = 0; i < hasRightBorder.length; ++i) {
                if (hasRightBorder[i] && hasLeftBorder[i]) continue;
                this.isBadTable = true;
                return this.isBadTable;
            }
        }
        return this.isBadTable;
    }

    private boolean processMergedCells(TableBorderRow[] rows, int numberOfRows, int numberOfColumns) {
        int colNumber;
        int rowNumber;
        for (rowNumber = numberOfRows - 2; rowNumber >= 0; --rowNumber) {
            if (rows[rowNumber].cells[numberOfColumns - 1].rowSpan == 1) continue;
            rows[rowNumber].cells[numberOfColumns - 1].rowSpan = rows[rowNumber + 1].cells[numberOfColumns - 1].rowSpan + 1;
        }
        for (int colNumber2 = numberOfColumns - 2; colNumber2 >= 0; --colNumber2) {
            if (rows[numberOfRows - 1].cells[colNumber2].colSpan == 1) continue;
            rows[numberOfRows - 1].cells[colNumber2].colSpan = rows[numberOfRows - 1].cells[colNumber2 + 1].colSpan + 1;
        }
        for (rowNumber = numberOfRows - 2; rowNumber >= 0; --rowNumber) {
            for (colNumber = numberOfColumns - 2; colNumber >= 0; --colNumber) {
                if (rows[rowNumber].cells[colNumber].colSpan != 1) {
                    rows[rowNumber].cells[colNumber].colSpan = rows[rowNumber].cells[colNumber + 1].colSpan + 1;
                }
                if (rows[rowNumber].cells[colNumber].rowSpan == 1) continue;
                rows[rowNumber].cells[colNumber].rowSpan = rows[rowNumber + 1].cells[colNumber].rowSpan + 1;
            }
        }
        for (rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            for (colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
                if (rows[rowNumber].cells[colNumber].colNumber + rows[rowNumber].cells[colNumber].colSpan > colNumber + 1) {
                    if (rows[rowNumber].cells[colNumber + 1].rowNumber + rows[rowNumber].cells[colNumber + 1].rowSpan == rows[rowNumber].cells[colNumber].rowNumber + rows[rowNumber].cells[colNumber].rowSpan) {
                        rows[rowNumber].cells[colNumber + 1] = rows[rowNumber].cells[colNumber];
                    } else {
                        this.isBadTable = true;
                        return true;
                    }
                }
                if (rows[rowNumber].cells[colNumber].rowNumber + rows[rowNumber].cells[colNumber].rowSpan <= rowNumber + 1) continue;
                if (rows[rowNumber + 1].cells[colNumber].colNumber + rows[rowNumber + 1].cells[colNumber].colSpan == rows[rowNumber].cells[colNumber].colNumber + rows[rowNumber].cells[colNumber].colSpan) {
                    rows[rowNumber + 1].cells[colNumber] = rows[rowNumber].cells[colNumber];
                    continue;
                }
                this.isBadTable = true;
                return true;
            }
        }
        return false;
    }

    private void detectRedundantRows(List<Integer> redundantRows, List<Integer> usefulRows, TableBorderRow[] rows, int numberOfRows, int numberOfColumns) {
        for (int rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            boolean redundantRow = true;
            for (int colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
                if (rows[rowNumber].cells[colNumber].rowNumber != rowNumber) continue;
                redundantRow = false;
                break;
            }
            if (redundantRow) {
                redundantRows.add(rowNumber);
                continue;
            }
            usefulRows.add(rowNumber);
        }
    }

    private void detectRedundantColumns(List<Integer> redundantColumns, List<Integer> usefulColumns, TableBorderRow[] rows, int numberOfRows, int numberOfColumns) {
        for (int colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
            boolean redundantColumn = true;
            for (int rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
                if (rows[rowNumber].cells[colNumber].colNumber != colNumber) continue;
                redundantColumn = false;
                break;
            }
            if (redundantColumn) {
                redundantColumns.add(colNumber);
                continue;
            }
            usefulColumns.add(colNumber);
        }
    }

    private void deleteRedundantRowsAndColumns(TableBorderRow[] rows, int numberOfRows, int numberOfColumns, List<Integer> redundantRows, List<Integer> usefulRows, List<Integer> redundantColumns, List<Integer> usefulColumns) {
        int rowNumber;
        for (int rowNumber2 = 0; rowNumber2 < numberOfRows; ++rowNumber2) {
            for (Integer columnNumber : redundantColumns) {
                if (rows[rowNumber2].cells[columnNumber.intValue()].rowNumber != rowNumber2) continue;
                --rows[rowNumber2].cells[columnNumber.intValue()].colSpan;
            }
        }
        for (Integer rowNumber3 : redundantRows) {
            for (int colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
                if (rows[rowNumber3.intValue()].cells[colNumber].colNumber != colNumber) continue;
                --rows[rowNumber3.intValue()].cells[colNumber].rowSpan;
            }
        }
        this.numberOfRows = usefulRows.size();
        this.numberOfColumns = usefulColumns.size();
        for (int colNumber = redundantColumns.size() - 1; colNumber >= 0; --colNumber) {
            int oldColNumber = redundantColumns.get(colNumber);
            this.xCoordinates.remove(oldColNumber);
            this.xWidths.remove(oldColNumber);
        }
        for (rowNumber = redundantRows.size() - 1; rowNumber >= 0; --rowNumber) {
            int oldRowNumber = redundantRows.get(rowNumber);
            this.yCoordinates.remove(oldRowNumber);
            this.yWidths.remove(oldRowNumber);
        }
        this.rows = new TableBorderRow[this.numberOfRows];
        for (rowNumber = 0; rowNumber < this.numberOfRows; ++rowNumber) {
            int oldRowNumber = usefulRows.get(rowNumber);
            this.rows[rowNumber] = new TableBorderRow(rowNumber, this.numberOfColumns, this.getRecognizedStructureId());
            this.rows[rowNumber].setBoundingBox(rows[oldRowNumber].getBoundingBox());
            for (int colNumber = 0; colNumber < this.numberOfColumns; ++colNumber) {
                int oldColNumber = usefulColumns.get(colNumber);
                if (rows[oldRowNumber].cells[oldColNumber].rowNumber == oldRowNumber && rows[oldRowNumber].cells[oldColNumber].colNumber == oldColNumber) {
                    rows[oldRowNumber].cells[oldColNumber].rowNumber = rowNumber;
                    rows[oldRowNumber].cells[oldColNumber].colNumber = colNumber;
                }
                this.rows[rowNumber].cells[colNumber] = rows[oldRowNumber].cells[oldColNumber];
            }
        }
    }

    private int getCoordinateX(double x) {
        for (int i = 0; i < this.xCoordinates.size(); ++i) {
            if (!(x <= this.getRightX(i - 1) + 1.0E-4) || !(x >= this.getLeftX(i) - 1.0E-4)) continue;
            return i;
        }
        return -1;
    }

    private int getCoordinateY(double y) {
        for (int i = 0; i < this.yCoordinates.size(); ++i) {
            if (!(y <= this.getTopY(i) + 1.0E-4) || !(y >= this.getBottomY(i - 1) - 1.0E-4)) continue;
            return i;
        }
        return -1;
    }

    private int getClosestLeftX(double x) {
        for (int i = this.xCoordinates.size() - 1; i >= 0; --i) {
            if (!(x >= this.getLeftX(i) - 0.6)) continue;
            return i;
        }
        return -1;
    }

    private int getClosestRightX(double x) {
        for (int i = 0; i < this.xCoordinates.size(); ++i) {
            if (!(x <= this.getRightX(i - 1) + 0.6)) continue;
            return i;
        }
        return this.xCoordinates.size();
    }

    private int getClosestTopY(double y) {
        for (int i = this.yCoordinates.size() - 1; i >= 0; --i) {
            if (!(y <= this.getTopY(i) + 0.6)) continue;
            return i;
        }
        return -1;
    }

    private int getClosestBottomY(double y) {
        for (int i = 0; i < this.yCoordinates.size(); ++i) {
            if (!(y >= this.getBottomY(i - 1) - 0.6)) continue;
            return i;
        }
        return this.yCoordinates.size();
    }

    private void calculateCoordinatesUsingBoundingBoxesOfRowsAndColumns() {
        this.yCoordinates.add(this.getTableRowTopY(0));
        this.yWidths.add(0.0);
        for (int rowNumber = 0; rowNumber < this.numberOfRows - 1; ++rowNumber) {
            this.yCoordinates.add(0.5 * (this.getTableRowBottomY(rowNumber) + this.getTableRowTopY(rowNumber + 1)));
            this.yWidths.add(0.0);
        }
        this.yCoordinates.add(this.getTableRowBottomY(this.numberOfRows - 1));
        this.yWidths.add(0.0);
        this.xCoordinates.add(this.getTableColumnLeftX(0));
        this.xWidths.add(0.0);
        for (int columnNumber = 0; columnNumber < this.numberOfColumns - 1; ++columnNumber) {
            this.xCoordinates.add(0.5 * (this.getTableColumnRightX(columnNumber) + this.getTableColumnLeftX(columnNumber + 1)));
            this.xWidths.add(0.0);
        }
        this.xCoordinates.add(this.getTableColumnRightX(this.numberOfColumns - 1));
        this.xWidths.add(0.0);
    }

    private double getTableColumnRightX(int columnNumber) {
        double rightX = -1.7976931348623157E308;
        for (int rowNumber = 0; rowNumber < this.numberOfRows; ++rowNumber) {
            TableBorderCell currentCell = this.rows[rowNumber].getCell(columnNumber);
            if (currentCell.getRowNumber() != rowNumber || currentCell.getColNumber() + currentCell.getColSpan() != columnNumber + 1 || !(rightX < currentCell.getRightX())) continue;
            rightX = currentCell.getRightX();
        }
        return rightX;
    }

    private double getTableColumnLeftX(int columnNumber) {
        double leftX = Double.MAX_VALUE;
        for (int rowNumber = 0; rowNumber < this.numberOfRows; ++rowNumber) {
            TableBorderCell currentCell = this.rows[rowNumber].getCell(columnNumber);
            if (currentCell.getRowNumber() != rowNumber || currentCell.getColNumber() != columnNumber || !(leftX > currentCell.getLeftX())) continue;
            leftX = currentCell.getLeftX();
        }
        return leftX;
    }

    private double getTableRowBottomY(int rowNumber) {
        double bottomY = Double.MAX_VALUE;
        for (int columnNumber = 0; columnNumber < this.numberOfColumns; ++columnNumber) {
            TableBorderCell currentCell = this.rows[rowNumber].getCell(columnNumber);
            if (currentCell.getRowNumber() + currentCell.getRowSpan() != rowNumber + 1 || currentCell.getColNumber() != columnNumber || !(bottomY > currentCell.getBottomY())) continue;
            bottomY = currentCell.getBottomY();
        }
        return bottomY;
    }

    private double getTableRowTopY(int rowNumber) {
        double topY = -1.7976931348623157E308;
        for (int columnNumber = 0; columnNumber < this.numberOfColumns; ++columnNumber) {
            TableBorderCell currentCell = this.rows[rowNumber].getCell(columnNumber);
            if (currentCell.getRowNumber() != rowNumber || currentCell.getColNumber() != columnNumber || !(topY < currentCell.getTopY())) continue;
            topY = currentCell.getTopY();
        }
        return topY;
    }

    public double getLeftX(int columnNumber) {
        return this.xCoordinates.get(columnNumber) - 0.5 * this.xWidths.get(columnNumber);
    }

    public double getBottomY(int rowNumber) {
        return this.yCoordinates.get(rowNumber + 1) - 0.5 * this.yWidths.get(rowNumber + 1);
    }

    public double getRightX(int columnNumber) {
        return this.xCoordinates.get(columnNumber + 1) + 0.5 * this.xWidths.get(columnNumber + 1);
    }

    public double getTopY(int rowNumber) {
        return this.yCoordinates.get(rowNumber) + 0.5 * this.yWidths.get(rowNumber);
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public INode getNode() {
        return this.node;
    }

    public void setNode(INode node) {
        this.node = node;
    }

    public boolean isBadTable() {
        return this.isBadTable || this.numberOfRows < 1 || this.numberOfColumns < 1 || !StaticContainers.isDataLoader() && this.numberOfRows == 1 && this.numberOfColumns == 1;
    }

    public boolean isOneCellTable() {
        return this.numberOfRows == 1 && this.numberOfColumns == 1;
    }

    public boolean isTextBlock() {
        return this.isOneCellTable() && !this.getCell(0, 0).getContents().isEmpty();
    }

    public Long getPreviousTableId() {
        return this.previousTable != null ? this.previousTable.getRecognizedStructureId() : null;
    }

    public Long getNextTableId() {
        return this.nextTable != null ? this.nextTable.getRecognizedStructureId() : null;
    }

    public TableBorder getPreviousTable() {
        return this.previousTable;
    }

    public void setPreviousTable(TableBorder previousTable) {
        this.previousTable = previousTable;
    }

    public boolean checkTableCoordinates() {
        int i;
        for (i = 0; i < this.xCoordinates.size() - 1; ++i) {
            if (!(this.xCoordinates.get(i) > this.xCoordinates.get(i + 1))) continue;
            return false;
        }
        for (i = 0; i < this.yCoordinates.size() - 1; ++i) {
            if (!(this.yCoordinates.get(i) < this.yCoordinates.get(i + 1))) continue;
            return false;
        }
        return true;
    }

    public boolean checkEmptyRowsOrColumns() {
        for (int rowNumber = 0; rowNumber < this.numberOfRows; ++rowNumber) {
            if (NodeUtils.areCloseNumbers(this.getTableRowBottomY(rowNumber), Double.MAX_VALUE)) {
                return false;
            }
            if (!NodeUtils.areCloseNumbers(this.getTableRowTopY(rowNumber), -1.7976931348623157E308)) continue;
            return false;
        }
        for (int columnNumber = 0; columnNumber < this.numberOfColumns; ++columnNumber) {
            if (NodeUtils.areCloseNumbers(this.getTableColumnLeftX(columnNumber), Double.MAX_VALUE)) {
                return false;
            }
            if (!NodeUtils.areCloseNumbers(this.getTableColumnRightX(columnNumber), -1.7976931348623157E308)) continue;
            return false;
        }
        return true;
    }

    private void addContentToCell(TableBorderCell cell, BoundingBox boundingBox, INode elem) {
        for (INode child : elem.getChildren()) {
            if (child instanceof SemanticSpan) {
                cell.addContentObject(((SemanticSpan)child).getColumns().get(0).getFirstLine().getFirstTextChunk());
                boundingBox.union(child.getBoundingBox());
                continue;
            }
            if (child instanceof SemanticFigure) {
                cell.addContentObject(child);
                boundingBox.union(child.getBoundingBox());
                continue;
            }
            this.addContentToCell(cell, boundingBox, child);
        }
    }

    public TableBorder getNextTable() {
        return this.nextTable;
    }

    public void setNextTable(TableBorder nextTable) {
        this.nextTable = nextTable;
    }

    public boolean isTableTransformer() {
        return this.isTableTransformer;
    }

    public TableBorderCell getTableBorderCell(IObject object) {
        BoundingBox box = object.getBoundingBox();
        int xLeftIndex = this.getClosestLeftX(box.getLeftX());
        int xRightIndex = this.getClosestRightX(box.getRightX());
        int yTopIndex = this.getClosestTopY(box.getTopY());
        int yBottomIndex = this.getClosestBottomY(box.getBottomY());
        if (xLeftIndex == this.xCoordinates.size() - 1 || yTopIndex == this.yCoordinates.size() - 1 || xRightIndex == 0 || yBottomIndex == 0) {
            return null;
        }
        if (xLeftIndex < 0) {
            xLeftIndex = 0;
        }
        if (yTopIndex < 0) {
            yTopIndex = 0;
        }
        if (xRightIndex == this.xCoordinates.size()) {
            --xRightIndex;
        }
        if (yBottomIndex == this.yCoordinates.size()) {
            --yBottomIndex;
        }
        while (xLeftIndex >= xRightIndex) {
            --xLeftIndex;
            ++xRightIndex;
        }
        while (yTopIndex >= yBottomIndex) {
            --yTopIndex;
            ++yBottomIndex;
        }
        for (int xIndex = xLeftIndex; xIndex < xRightIndex; ++xIndex) {
            for (int yIndex = yTopIndex; yIndex < yBottomIndex; ++yIndex) {
                TableBorderCell cell = this.rows[yIndex].cells[xIndex];
                if (!(box.getIntersectionPercent(cell.getBoundingBox()) > 0.6)) continue;
                return cell;
            }
        }
        return null;
    }

    public Set<TableBorderCell> getTableBorderCells(IObject object) {
        BoundingBox box = object.getBoundingBox();
        int xLeftIndex = this.getClosestLeftX(box.getLeftX());
        int xRightIndex = this.getClosestRightX(box.getRightX());
        int yTopIndex = this.getClosestTopY(box.getTopY());
        int yBottomIndex = this.getClosestBottomY(box.getBottomY());
        if (xLeftIndex == this.xCoordinates.size() - 1 || yTopIndex == this.yCoordinates.size() - 1 || xRightIndex == 0 || yBottomIndex == 0) {
            return Collections.emptySet();
        }
        if (xLeftIndex < 0) {
            xLeftIndex = 0;
        }
        if (yTopIndex < 0) {
            yTopIndex = 0;
        }
        if (xRightIndex == this.xCoordinates.size()) {
            --xRightIndex;
        }
        if (yBottomIndex == this.yCoordinates.size()) {
            --yBottomIndex;
        }
        while (xLeftIndex >= xRightIndex) {
            --xLeftIndex;
            ++xRightIndex;
        }
        while (yTopIndex >= yBottomIndex) {
            --yTopIndex;
            ++yBottomIndex;
        }
        HashSet<TableBorderCell> cells = new HashSet<TableBorderCell>();
        int rowNumber = this.getRowNumber(yTopIndex, yBottomIndex, box);
        for (int xIndex = xLeftIndex; xIndex < xRightIndex; ++xIndex) {
            TableBorderCell cell = this.rows[rowNumber].cells[xIndex];
            cells.add(cell);
        }
        return cells;
    }

    private int getRowNumber(int yTopIndex, int yBottomIndex, BoundingBox box) {
        if (yTopIndex + 1 == yBottomIndex) {
            return yTopIndex;
        }
        double maxPercent = -1.7976931348623157E308;
        int rowNumber = 0;
        for (int yIndex = yTopIndex; yIndex < yBottomIndex; ++yIndex) {
            double percent = box.getVerticalIntersectionPercent(this.rows[yIndex].getBoundingBox());
            if (!(percent > maxPercent)) continue;
            maxPercent = percent;
            rowNumber = yIndex;
        }
        return rowNumber;
    }

    public static class TableBordersComparator
    implements Comparator<TableBorder> {
        @Override
        public int compare(TableBorder border1, TableBorder border2) {
            int res = Double.compare(border2.getBoundingBox().getTopY(), border1.getBoundingBox().getTopY());
            if (res != 0) {
                return res;
            }
            return Double.compare(border1.getBoundingBox().getLeftX(), border2.getBoundingBox().getLeftX());
        }
    }
}

