/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.Vertex;

public class TableBorderBuilder {
    private final BoundingBox boundingBox;
    private final Set<Vertex> vertexes = new HashSet<Vertex>();
    private final SortedSet<LineChunk> horizontalLines = new TreeSet<LineChunk>(new LineChunk.HorizontalLineComparator());
    private final SortedSet<LineChunk> verticalLines = new TreeSet<LineChunk>(new LineChunk.VerticalLineComparator());
    private double maxVertexRadius = 0.0;

    public TableBorderBuilder(LineChunk lineChunk) {
        this.boundingBox = new BoundingBox(lineChunk.getBoundingBox());
        this.addLine(lineChunk);
    }

    public void addVertex(Vertex v) {
        this.vertexes.add(v);
        if (this.maxVertexRadius < v.getRadius()) {
            this.maxVertexRadius = v.getRadius();
        }
    }

    public void addLine(LineChunk lineChunk) {
        if (lineChunk.isHorizontalLine()) {
            this.horizontalLines.add(lineChunk);
        } else if (lineChunk.isVerticalLine()) {
            this.verticalLines.add(lineChunk);
        }
        this.boundingBox.union(lineChunk.getBoundingBox());
        this.addVertex(lineChunk.getStart());
        if (!lineChunk.isSquare()) {
            this.addVertex(lineChunk.getEnd());
        }
    }

    public boolean isConnectedBorder(TableBorderBuilder border) {
        if (!this.boundingBox.overlaps(border.boundingBox, this.maxVertexRadius + border.maxVertexRadius)) {
            return false;
        }
        for (LineChunk horizontalLine : this.getHorizontalLines()) {
            for (LineChunk verticalLine : border.getVerticalLines()) {
                if (!LineChunk.haveIntersection(horizontalLine, verticalLine)) continue;
                return true;
            }
        }
        for (LineChunk verticalLine : this.getVerticalLines()) {
            for (LineChunk horizontalLine : border.getHorizontalLines()) {
                if (!LineChunk.haveIntersection(horizontalLine, verticalLine)) continue;
                return true;
            }
        }
        for (Vertex vertex1 : this.vertexes) {
            for (Vertex vertex2 : border.vertexes) {
                if (!Vertex.areCloseVertexes(vertex1, vertex2)) continue;
                return true;
            }
        }
        return false;
    }

    public void mergeBorder(TableBorderBuilder border) {
        Vertex v;
        for (LineChunk horizontalLine : border.getHorizontalLines()) {
            for (LineChunk verticalLine : this.verticalLines) {
                v = LineChunk.getIntersectionVertex(horizontalLine, verticalLine);
                if (v == null) continue;
                this.vertexes.add(v);
            }
        }
        for (LineChunk horizontalLine : this.horizontalLines) {
            for (LineChunk verticalLine : border.getVerticalLines()) {
                v = LineChunk.getIntersectionVertex(horizontalLine, verticalLine);
                if (v == null) continue;
                this.vertexes.add(v);
            }
        }
        this.verticalLines.addAll(border.getVerticalLines());
        this.horizontalLines.addAll(border.getHorizontalLines());
        this.boundingBox.union(border.boundingBox);
        this.vertexes.addAll(border.getVertexes());
    }

    public int getVertexesNumber() {
        return this.vertexes.size();
    }

    public Set<LineChunk> getVerticalLines() {
        return this.verticalLines;
    }

    public Set<LineChunk> getHorizontalLines() {
        return this.horizontalLines;
    }

    public int getVerticalLinesNumber() {
        return this.verticalLines.size();
    }

    public int getHorizontalLinesNumber() {
        return this.horizontalLines.size();
    }

    public Set<Vertex> getVertexes() {
        return this.vertexes;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public static class TableBorderBuildersComparator
    implements Comparator<TableBorderBuilder> {
        @Override
        public int compare(TableBorderBuilder builder1, TableBorderBuilder builder2) {
            int res = Double.compare(builder2.getBoundingBox().getTopY(), builder1.getBoundingBox().getTopY());
            if (res != 0) {
                return res;
            }
            return Double.compare(builder1.getBoundingBox().getLeftX(), builder2.getBoundingBox().getLeftX());
        }
    }
}

