/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities;

import java.util.LinkedList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.AnnotationNode;
import org.verapdf.wcag.algorithms.entities.SemanticNode;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;

public class SemanticAnnot
extends SemanticNode {
    protected final List<AnnotationNode> annotationNodes = new LinkedList<AnnotationNode>();

    public SemanticAnnot(SemanticAnnot annotationNode) {
        this.addAnnots(annotationNode.getAnnots());
        this.setSemanticType(SemanticType.ANNOT);
    }

    public SemanticAnnot(AnnotationNode annotationNode) {
        super(annotationNode.getBoundingBox());
        this.annotationNodes.add(annotationNode);
        this.setSemanticType(SemanticType.ANNOT);
    }

    public void addAnnots(List<AnnotationNode> annots) {
        this.annotationNodes.addAll(annots);
        for (AnnotationNode annotationNode : annots) {
            this.getBoundingBox().union(annotationNode.getBoundingBox());
        }
    }

    public List<AnnotationNode> getAnnots() {
        return this.annotationNodes;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SemanticAnnot)) {
            return false;
        }
        SemanticAnnot that = (SemanticAnnot)o;
        return this.annotationNodes.equals(that.getAnnots());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.annotationNodes.size();
        for (AnnotationNode annotationNode : this.annotationNodes) {
            result = 31 * result + annotationNode.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("SemanticAnnot{");
        result.append("pageNumber=");
        result.append(this.getBoundingBox().getPageNumber());
        result.append(", boundingBox=");
        result.append(this.getBoundingBox());
        result.append("}");
        return result.toString();
    }
}

