/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.lists;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.content.TextBlock;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.lists.ListBody;
import org.verapdf.wcag.algorithms.entities.lists.ListLabel;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;

public class ListItem
extends TextBlock {
    private final ListLabel label;
    private final ListBody body;
    private SemanticType semanticType;
    private List<IObject> contents = new ArrayList<IObject>();

    public ListItem(TableRow tableRow) {
        super(tableRow.getBoundingBox(), tableRow.getFontSize(), tableRow.getBaseLine());
        this.semanticType = SemanticType.LIST_ITEM;
        this.label = new ListLabel(tableRow.getCells().get(0));
        this.body = new ListBody(tableRow.getCells().get(1));
        this.setRecognizedStructureId(tableRow.getId());
    }

    public ListItem(BoundingBox boundingBox, Long id) {
        super(boundingBox);
        this.label = null;
        this.body = null;
        this.setRecognizedStructureId(id);
    }

    public void add(TableRow tableRow) {
        this.label.add(tableRow.getCells().get(0));
        this.body.add(tableRow.getCells().get(1));
        super.add(tableRow);
    }

    public void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    public ListLabel getLabel() {
        return this.label;
    }

    public ListBody getBody() {
        return this.body;
    }

    public List<IObject> getContents() {
        return this.contents;
    }

    public void setContents(List<IObject> contents) {
        this.contents = contents;
    }
}

