/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables.tableBorders;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.verapdf.wcag.algorithms.entities.BaseObject;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.Vertex;
import org.verapdf.wcag.algorithms.entities.tables.TableBorderBuilder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderRow;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;

public class TableBorder
extends BaseObject {
    public static final double TABLE_BORDER_EPSILON = 0.6;
    private static final double MIN_CELL_CONTENT_INTERSECTION_PERCENT = 0.8;
    private final List<Double> xCoordinates = new LinkedList<Double>();
    private final List<Double> xWidths = new LinkedList<Double>();
    private final List<Double> yCoordinates;
    private final List<Double> yWidths;
    private TableBorderRow[] rows;
    private int numberOfRows;
    private int numberOfColumns;
    private INode node;
    private boolean isBadTable = false;

    public TableBorder(TableBorderBuilder builder) {
        super(new BoundingBox(builder.getBoundingBox()));
        this.calculateXCoordinates(builder);
        this.yCoordinates = new LinkedList<Double>();
        this.yWidths = new LinkedList<Double>();
        this.calculateYCoordinates(builder);
        this.createMatrix(builder);
        this.setRecognizedStructureId(StaticContainers.getNextID());
    }

    private void calculateXCoordinates(TableBorderBuilder builder) {
        List vertexes = builder.getVertexes().stream().sorted(new Vertex.VertexComparatorX()).collect(Collectors.toList());
        double x1 = ((Vertex)vertexes.get(0)).getLeftX();
        double x2 = ((Vertex)vertexes.get(0)).getRightX();
        for (Vertex v : vertexes) {
            if (x2 < v.getLeftX() - 0.011) {
                this.xCoordinates.add(0.5 * (x1 + x2));
                this.xWidths.add(x2 - x1);
                x1 = v.getLeftX();
                x2 = v.getRightX();
                continue;
            }
            if (!(x2 < v.getRightX())) continue;
            x2 = v.getRightX();
        }
        this.xCoordinates.add(0.5 * (x1 + x2));
        this.xWidths.add(x2 - x1);
    }

    public TableBorderRow[] getRows() {
        return this.rows;
    }

    public TableBorderRow getRow(int rowNumber) {
        return this.rows[rowNumber];
    }

    public int getNumberOfRowsWithContent() {
        int numberOfRowsWithContent = 0;
        for (TableBorderRow row : this.rows) {
            if (row.getNumberOfCellWithContent() <= 0) continue;
            ++numberOfRowsWithContent;
        }
        return numberOfRowsWithContent;
    }

    private void calculateYCoordinates(TableBorderBuilder builder) {
        List vertexes = builder.getVertexes().stream().sorted(new Vertex.VertexComparatorY()).collect(Collectors.toList());
        double y1 = ((Vertex)vertexes.get(0)).getTopY();
        double y2 = ((Vertex)vertexes.get(0)).getBottomY();
        for (Vertex v : vertexes) {
            if (y2 > v.getTopY() + 0.011) {
                this.yCoordinates.add(0.5 * (y1 + y2));
                this.yWidths.add(y1 - y2);
                y1 = v.getTopY();
                y2 = v.getBottomY();
                continue;
            }
            if (!(y2 > v.getBottomY())) continue;
            y2 = v.getBottomY();
        }
        this.yCoordinates.add(0.5 * (y1 + y2));
        this.yWidths.add(y1 - y2);
    }

    private void createMatrix(TableBorderBuilder builder) {
        int rowNumber;
        int numberOfRows = this.yCoordinates.size() - 1;
        int numberOfColumns = this.xCoordinates.size() - 1;
        if (numberOfColumns < 1 || numberOfRows < 1) {
            return;
        }
        TableBorderRow[] rows = new TableBorderRow[numberOfRows];
        for (rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            rows[rowNumber] = new TableBorderRow(rowNumber, numberOfColumns, this.getRecognizedStructureId());
            for (int colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
                rows[rowNumber].cells[colNumber] = new TableBorderCell(rowNumber, colNumber, numberOfRows - rowNumber, numberOfColumns - colNumber, this.getRecognizedStructureId());
            }
        }
        if (this.processHorizontalLines(rows, numberOfRows, numberOfColumns, builder) || this.processVerticalLines(rows, numberOfRows, numberOfColumns, builder)) {
            return;
        }
        if (this.processMergedCells(rows, numberOfRows, numberOfColumns)) {
            return;
        }
        for (rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            MultiBoundingBox multiBoundingBox = new MultiBoundingBox();
            for (int colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
                if (rows[rowNumber].cells[colNumber].colNumber != colNumber || rows[rowNumber].cells[colNumber].rowNumber != rowNumber) continue;
                TableBorderCell cell = rows[rowNumber].cells[colNumber];
                BoundingBox cellBoundingBox = new BoundingBox(this.getBoundingBox().getPageNumber(), this.xCoordinates.get(colNumber) - 0.5 * this.xWidths.get(colNumber), this.yCoordinates.get(rowNumber + cell.rowSpan) - 0.5 * this.yWidths.get(rowNumber + cell.rowSpan), this.xCoordinates.get(colNumber + cell.colSpan) + 0.5 * this.xWidths.get(colNumber + cell.colSpan), this.yCoordinates.get(rowNumber) + 0.5 * this.yWidths.get(rowNumber));
                cell.setBoundingBox(cellBoundingBox);
                ((BoundingBox)multiBoundingBox).union(cellBoundingBox);
            }
            rows[rowNumber].setBoundingBox(multiBoundingBox);
        }
        ArrayList<Integer> redundantRows = new ArrayList<Integer>(numberOfRows);
        ArrayList<Integer> usefulRows = new ArrayList<Integer>(numberOfRows);
        this.detectRedundantRows(redundantRows, usefulRows, rows, numberOfRows, numberOfColumns);
        ArrayList<Integer> redundantColumns = new ArrayList<Integer>(numberOfColumns);
        ArrayList<Integer> usefulColumns = new ArrayList<Integer>(numberOfColumns);
        this.detectRedundantColumns(redundantColumns, usefulColumns, rows, numberOfRows, numberOfColumns);
        if (redundantColumns.isEmpty() && redundantRows.isEmpty()) {
            this.rows = rows;
            this.numberOfRows = numberOfRows;
            this.numberOfColumns = numberOfColumns;
            return;
        }
        this.deleteRedundantRowsAndColumns(rows, numberOfRows, numberOfColumns, redundantRows, usefulRows, redundantColumns, usefulColumns);
    }

    private boolean processHorizontalLines(TableBorderRow[] rows, int numberOfRows, int numberOfColumns, TableBorderBuilder builder) {
        boolean[] hasTopBorder = new boolean[numberOfColumns];
        boolean[] hasBottomBorder = new boolean[numberOfColumns];
        for (LineChunk line : builder.getHorizontalLines()) {
            int colNumber;
            int rowNumber = this.getCoordinateY(line.getCenterY());
            int firstColNumber = this.getCoordinateX(line.getLeftX());
            int lastColNumber = this.getCoordinateX(line.getRightX());
            if (rowNumber == -1 || firstColNumber == -1 || lastColNumber == -1) continue;
            if (rowNumber > 0 && rowNumber < numberOfRows) {
                for (colNumber = firstColNumber; colNumber < lastColNumber; ++colNumber) {
                    rows[rowNumber - 1].cells[colNumber].rowSpan = 1;
                }
                continue;
            }
            if (rowNumber == 0) {
                for (colNumber = firstColNumber; colNumber < lastColNumber; ++colNumber) {
                    hasTopBorder[colNumber] = true;
                }
                continue;
            }
            if (rowNumber != numberOfRows) continue;
            for (colNumber = firstColNumber; colNumber < lastColNumber; ++colNumber) {
                hasBottomBorder[colNumber] = true;
            }
        }
        for (int i = 0; i < hasBottomBorder.length; ++i) {
            if (hasBottomBorder[i] && hasTopBorder[i]) continue;
            this.isBadTable = true;
            break;
        }
        return this.isBadTable;
    }

    private boolean processVerticalLines(TableBorderRow[] rows, int numberOfRows, int numberOfColumns, TableBorderBuilder builder) {
        boolean[] hasLeftBorder = new boolean[numberOfRows];
        boolean[] hasRightBorder = new boolean[numberOfRows];
        for (LineChunk line : builder.getVerticalLines()) {
            int rowNumber;
            int colNumber = this.getCoordinateX(line.getCenterX());
            int firstRowNumber = this.getCoordinateY(line.getTopY());
            int lastRowNumber = this.getCoordinateY(line.getBottomY());
            if (firstRowNumber == -1 || lastRowNumber == -1 || colNumber == -1) continue;
            if (colNumber > 0 && colNumber < numberOfColumns) {
                for (rowNumber = firstRowNumber; rowNumber < lastRowNumber; ++rowNumber) {
                    rows[rowNumber].cells[colNumber - 1].colSpan = 1;
                }
                continue;
            }
            if (colNumber == 0) {
                for (rowNumber = firstRowNumber; rowNumber < lastRowNumber; ++rowNumber) {
                    hasLeftBorder[rowNumber] = true;
                }
                continue;
            }
            if (colNumber != numberOfColumns) continue;
            for (rowNumber = firstRowNumber; rowNumber < lastRowNumber; ++rowNumber) {
                hasRightBorder[rowNumber] = true;
            }
        }
        for (int i = 0; i < hasRightBorder.length; ++i) {
            if (hasRightBorder[i] && hasLeftBorder[i]) continue;
            this.isBadTable = true;
            break;
        }
        return this.isBadTable;
    }

    private boolean processMergedCells(TableBorderRow[] rows, int numberOfRows, int numberOfColumns) {
        int colNumber;
        int rowNumber;
        for (rowNumber = numberOfRows - 2; rowNumber >= 0; --rowNumber) {
            if (rows[rowNumber].cells[numberOfColumns - 1].rowSpan == 1) continue;
            rows[rowNumber].cells[numberOfColumns - 1].rowSpan = rows[rowNumber + 1].cells[numberOfColumns - 1].rowSpan + 1;
        }
        for (int colNumber2 = numberOfColumns - 2; colNumber2 >= 0; --colNumber2) {
            if (rows[numberOfRows - 1].cells[colNumber2].colSpan == 1) continue;
            rows[numberOfRows - 1].cells[colNumber2].colSpan = rows[numberOfRows - 1].cells[colNumber2 + 1].colSpan + 1;
        }
        for (rowNumber = numberOfRows - 2; rowNumber >= 0; --rowNumber) {
            for (colNumber = numberOfColumns - 2; colNumber >= 0; --colNumber) {
                if (rows[rowNumber].cells[colNumber].colSpan != 1) {
                    rows[rowNumber].cells[colNumber].colSpan = rows[rowNumber].cells[colNumber + 1].colSpan + 1;
                }
                if (rows[rowNumber].cells[colNumber].rowSpan == 1) continue;
                rows[rowNumber].cells[colNumber].rowSpan = rows[rowNumber + 1].cells[colNumber].rowSpan + 1;
            }
        }
        for (rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            for (colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
                if (rows[rowNumber].cells[colNumber].colNumber + rows[rowNumber].cells[colNumber].colSpan > colNumber + 1) {
                    if (rows[rowNumber].cells[colNumber + 1].rowNumber + rows[rowNumber].cells[colNumber + 1].rowSpan == rows[rowNumber].cells[colNumber].rowNumber + rows[rowNumber].cells[colNumber].rowSpan) {
                        rows[rowNumber].cells[colNumber + 1] = rows[rowNumber].cells[colNumber];
                    } else {
                        this.isBadTable = true;
                        return true;
                    }
                }
                if (rows[rowNumber].cells[colNumber].rowNumber + rows[rowNumber].cells[colNumber].rowSpan <= rowNumber + 1) continue;
                if (rows[rowNumber + 1].cells[colNumber].colNumber + rows[rowNumber + 1].cells[colNumber].colSpan == rows[rowNumber].cells[colNumber].colNumber + rows[rowNumber].cells[colNumber].colSpan) {
                    rows[rowNumber + 1].cells[colNumber] = rows[rowNumber].cells[colNumber];
                    continue;
                }
                this.isBadTable = true;
                return true;
            }
        }
        return false;
    }

    private void detectRedundantRows(List<Integer> redundantRows, List<Integer> usefulRows, TableBorderRow[] rows, int numberOfRows, int numberOfColumns) {
        for (int rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
            boolean redundantRow = true;
            for (int colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
                if (rows[rowNumber].cells[colNumber].rowNumber != rowNumber) continue;
                redundantRow = false;
                break;
            }
            if (redundantRow) {
                redundantRows.add(rowNumber);
                continue;
            }
            usefulRows.add(rowNumber);
        }
    }

    private void detectRedundantColumns(List<Integer> redundantColumns, List<Integer> usefulColumns, TableBorderRow[] rows, int numberOfRows, int numberOfColumns) {
        for (int colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
            boolean redundantColumn = true;
            for (int rowNumber = 0; rowNumber < numberOfRows; ++rowNumber) {
                if (rows[rowNumber].cells[colNumber].colNumber != colNumber) continue;
                redundantColumn = false;
                break;
            }
            if (redundantColumn) {
                redundantColumns.add(colNumber);
                continue;
            }
            usefulColumns.add(colNumber);
        }
    }

    private void deleteRedundantRowsAndColumns(TableBorderRow[] rows, int numberOfRows, int numberOfColumns, List<Integer> redundantRows, List<Integer> usefulRows, List<Integer> redundantColumns, List<Integer> usefulColumns) {
        int rowNumber;
        for (int rowNumber2 = 0; rowNumber2 < numberOfRows; ++rowNumber2) {
            for (Integer columnNumber : redundantColumns) {
                if (rows[rowNumber2].cells[columnNumber.intValue()].rowNumber != rowNumber2) continue;
                --rows[rowNumber2].cells[columnNumber.intValue()].colSpan;
            }
        }
        for (Integer rowNumber3 : redundantRows) {
            for (int colNumber = 0; colNumber < numberOfColumns; ++colNumber) {
                if (rows[rowNumber3.intValue()].cells[colNumber].colNumber != colNumber) continue;
                --rows[rowNumber3.intValue()].cells[colNumber].rowSpan;
            }
        }
        this.numberOfRows = usefulRows.size();
        this.numberOfColumns = usefulColumns.size();
        for (int colNumber = redundantColumns.size() - 1; colNumber >= 0; --colNumber) {
            int oldColNumber = redundantColumns.get(colNumber);
            this.xCoordinates.remove(oldColNumber);
            this.xWidths.remove(oldColNumber);
        }
        for (rowNumber = redundantRows.size() - 1; rowNumber >= 0; --rowNumber) {
            int oldRowNumber = redundantRows.get(rowNumber);
            this.yCoordinates.remove(oldRowNumber);
            this.yWidths.remove(oldRowNumber);
        }
        this.rows = new TableBorderRow[this.numberOfRows];
        for (rowNumber = 0; rowNumber < this.numberOfRows; ++rowNumber) {
            int oldRowNumber = usefulRows.get(rowNumber);
            this.rows[rowNumber] = new TableBorderRow(rowNumber, this.numberOfColumns, this.getRecognizedStructureId());
            this.rows[rowNumber].setBoundingBox(rows[oldRowNumber].getBoundingBox());
            for (int colNumber = 0; colNumber < this.numberOfColumns; ++colNumber) {
                int oldColNumber = usefulColumns.get(colNumber);
                if (rows[oldRowNumber].cells[oldColNumber].rowNumber == oldRowNumber && rows[oldRowNumber].cells[oldColNumber].colNumber == oldColNumber) {
                    rows[oldRowNumber].cells[oldColNumber].rowNumber = rowNumber;
                    rows[oldRowNumber].cells[oldColNumber].colNumber = colNumber;
                }
                this.rows[rowNumber].cells[colNumber] = rows[oldRowNumber].cells[oldColNumber];
            }
        }
    }

    private int getCoordinateX(double x) {
        for (int i = 0; i < this.xCoordinates.size(); ++i) {
            if (!(x <= this.xCoordinates.get(i) + 0.5 * this.xWidths.get(i) + 1.0E-4) || !(x >= this.xCoordinates.get(i) - 0.5 * this.xWidths.get(i) - 1.0E-4)) continue;
            return i;
        }
        return -1;
    }

    private int getCoordinateY(double y) {
        for (int i = 0; i < this.yCoordinates.size(); ++i) {
            if (!(y <= this.yCoordinates.get(i) + 0.5 * this.yWidths.get(i) + 1.0E-4) || !(y >= this.yCoordinates.get(i) - 0.5 * this.yWidths.get(i) - 1.0E-4)) continue;
            return i;
        }
        return -1;
    }

    private int getClosestLeftX(double x) {
        for (int i = this.xCoordinates.size() - 1; i >= 0; --i) {
            if (!(x >= this.xCoordinates.get(i) - 0.5 * this.xWidths.get(i) - 0.6)) continue;
            return i;
        }
        return -1;
    }

    private int getClosestRightX(double x) {
        for (int i = 0; i < this.xCoordinates.size(); ++i) {
            if (!(x <= this.xCoordinates.get(i) + 0.5 * this.xWidths.get(i) + 0.6)) continue;
            return i;
        }
        return this.xCoordinates.size();
    }

    private int getClosestTopY(double y) {
        for (int i = this.yCoordinates.size() - 1; i >= 0; --i) {
            if (!(y <= this.yCoordinates.get(i) + 0.5 * this.yWidths.get(i) + 0.6)) continue;
            return i;
        }
        return -1;
    }

    private int getClosestBottomY(double y) {
        for (int i = 0; i < this.yCoordinates.size(); ++i) {
            if (!(y >= this.yCoordinates.get(i) - 0.5 * this.yWidths.get(i) - 0.6)) continue;
            return i;
        }
        return this.yCoordinates.size();
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public INode getNode() {
        return this.node;
    }

    public void setNode(INode node) {
        this.node = node;
    }

    public boolean isBadTable() {
        return this.isBadTable || this.numberOfRows < 1 || this.numberOfColumns < 1 || this.numberOfRows == 1 && this.numberOfColumns == 1;
    }

    public TableBorderCell getTableBorderCell(BoundingBox box) {
        int xLeftIndex = this.getClosestLeftX(box.getLeftX());
        int xRightIndex = this.getClosestRightX(box.getRightX());
        int yTopIndex = this.getClosestTopY(box.getTopY());
        int yBottomIndex = this.getClosestBottomY(box.getBottomY());
        if (xLeftIndex == this.xCoordinates.size() - 1 || yTopIndex == this.yCoordinates.size() - 1 || xRightIndex == 0 || yBottomIndex == 0) {
            return null;
        }
        if (xLeftIndex < 0) {
            xLeftIndex = 0;
        }
        if (yTopIndex < 0) {
            yTopIndex = 0;
        }
        if (xRightIndex == this.xCoordinates.size()) {
            --xRightIndex;
        }
        if (yBottomIndex == this.yCoordinates.size()) {
            --yBottomIndex;
        }
        if (xLeftIndex >= xRightIndex || yTopIndex >= yBottomIndex) {
            return null;
        }
        for (int xIndex = xLeftIndex; xIndex < xRightIndex; ++xIndex) {
            for (int yIndex = yTopIndex; yIndex < yBottomIndex; ++yIndex) {
                TableBorderCell cell = this.rows[yIndex].cells[xIndex];
                if (!(TableBorder.getIntersectionPercent(cell, box) > 0.8)) continue;
                return cell;
            }
        }
        return null;
    }

    private static double getIntersectionPercent(TableBorderCell cell, BoundingBox boundingBox) {
        double xIntersection = Math.min(Math.min(cell.getWidth(), boundingBox.getWidth()), Math.min(cell.getRightX() - boundingBox.getLeftX(), boundingBox.getRightX() - cell.getLeftX()));
        double yIntersection = Math.min(Math.min(cell.getHeight(), boundingBox.getHeight()), Math.min(cell.getTopY() - boundingBox.getBottomY(), boundingBox.getTopY() - cell.getBottomY()));
        if (xIntersection <= 0.0 || yIntersection <= 0.0) {
            return 0.0;
        }
        return xIntersection / boundingBox.getWidth() * (yIntersection / boundingBox.getHeight());
    }

    public static class TableBordersComparator
    implements Comparator<TableBorder> {
        @Override
        public int compare(TableBorder border1, TableBorder border2) {
            int res = Double.compare(border2.getBoundingBox().getTopY(), border1.getBoundingBox().getTopY());
            if (res != 0) {
                return res;
            }
            return Double.compare(border1.getBoundingBox().getLeftX(), border2.getBoundingBox().getLeftX());
        }
    }
}

