/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.enums.TextFormat;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;

public class TextChunk
extends TextInfoChunk {
    private String value;
    private String fontName;
    private double fontWeight;
    private double italicAngle;
    private double[] fontColor;
    private double contrastRatio = 2.147483647E9;
    private boolean hasSpecialStyle = false;
    private boolean hasSpecialBackground = false;
    private double[] backgroundColor;
    private boolean isUnderlinedText = false;
    private TextFormat textFormat = TextFormat.NORMAL;
    private List<Double> symbolEnds;

    public TextChunk() {
    }

    public TextChunk(String value) {
        this.value = value;
    }

    public TextChunk(BoundingBox bbox, String value, double fontSize, double baseLine) {
        super(bbox, fontSize, baseLine);
        this.value = value;
    }

    public TextChunk(BoundingBox bbox, String value, String fontName, double fontSize, double fontWeight, double italicAngle, double baseLine, double[] fontColor, List<Double> symbolEnds, double slantDegree) {
        this(bbox, value, fontName, fontSize, fontWeight, italicAngle, baseLine, fontColor, slantDegree);
        if (symbolEnds == null) {
            this.adjustSymbolEndsToBoundingBox(null);
        } else {
            this.symbolEnds = symbolEnds;
        }
    }

    public TextChunk(BoundingBox bbox, String value, String fontName, double fontSize, double fontWeight, double italicAngle, double baseLine, double[] fontColor, double slantDegree) {
        super(bbox, fontSize, baseLine, slantDegree);
        this.value = value;
        this.fontName = fontName;
        this.fontWeight = fontWeight;
        this.italicAngle = italicAngle;
        this.fontColor = (double[])fontColor.clone();
    }

    public TextChunk(TextChunk chunk) {
        this(chunk.getBoundingBox(), chunk.value, chunk.fontName, chunk.fontSize, chunk.fontWeight, chunk.italicAngle, chunk.baseLine, chunk.fontColor, chunk.symbolEnds, chunk.slantDegree);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public double getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(double fontWeight) {
        this.fontWeight = fontWeight;
    }

    public double getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(double italicAngle) {
        this.italicAngle = italicAngle;
    }

    public double[] getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(double[] fontColor) {
        this.fontColor = fontColor;
    }

    public double getContrastRatio() {
        return this.contrastRatio;
    }

    public void setContrastRatio(double contrastRatio) {
        this.contrastRatio = contrastRatio;
    }

    public boolean getHasSpecialStyle() {
        return this.hasSpecialStyle;
    }

    public void setHasSpecialStyle() {
        this.hasSpecialStyle = true;
    }

    public boolean getHasSpecialBackground() {
        return this.hasSpecialBackground;
    }

    public void setHasSpecialBackground() {
        this.hasSpecialBackground = true;
    }

    public double[] getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(double[] backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean getIsUnderlinedText() {
        return this.isUnderlinedText;
    }

    public void setIsUnderlinedText() {
        this.isUnderlinedText = true;
    }

    public TextFormat getTextFormat() {
        return this.textFormat;
    }

    public void setTextFormat(TextFormat textFormat) {
        this.textFormat = textFormat;
    }

    public List<Double> getSymbolEnds() {
        return this.symbolEnds;
    }

    public void setSymbolEnds(List<Double> symbolEnds) {
        this.symbolEnds = symbolEnds;
    }

    public Double getSymbolStartCoordinate(int index) {
        return index >= 0 && index < this.symbolEnds.size() - 1 ? this.symbolEnds.get(index) : null;
    }

    public Double getSymbolEndCoordinate(int index) {
        return index >= 0 && index < this.symbolEnds.size() - 1 ? this.symbolEnds.get(index + 1) : null;
    }

    public Double getSymbolWidth(int index) {
        return index >= 0 && index < this.symbolEnds.size() - 1 ? Double.valueOf(this.symbolEnds.get(index + 1) - this.symbolEnds.get(index)) : null;
    }

    public void adjustSymbolEndsToBoundingBox(List<Double> symbolEnds) {
        double textStart = this.getTextStart();
        double textEnd = this.getTextEnd();
        if (symbolEnds == null) {
            this.symbolEnds = new ArrayList<Double>(this.value.length() + 1);
            double symbolEnd = textStart;
            this.symbolEnds.add(symbolEnd);
            double averageWidth = (textEnd - textStart) / (double)this.value.length();
            for (int i = 0; i < this.value.length(); ++i) {
                this.symbolEnds.add(symbolEnd += averageWidth);
            }
            return;
        }
        double multiplier = (textEnd - textStart) / (symbolEnds.get(symbolEnds.size() - 1) - symbolEnds.get(0));
        this.symbolEnds = symbolEnds.stream().map(e -> textStart + e * multiplier).collect(Collectors.toList());
    }

    public double getAverageSymbolWidth() {
        return this.getTextLength() / (double)this.getValue().length();
    }

    public double getTextLength() {
        if (this.isHorizontalText()) {
            return this.getBoundingBox().getWidth();
        }
        if (this.isVerticalText()) {
            return this.getBoundingBox().getHeight();
        }
        return this.getBoundingBox().getWidth();
    }

    public void addAll(List<TextChunk> otherChunks) {
        StringBuilder text = new StringBuilder(this.value);
        for (TextChunk chunk : otherChunks) {
            text.append(chunk.getValue());
            super.add(chunk);
        }
        this.value = text.toString();
    }

    public void add(TextChunk chunk) {
        this.value = this.value + chunk.getValue();
        super.add(chunk);
    }

    public boolean isEmpty() {
        return this.value.isEmpty() || this.value.matches("\u0000+");
    }

    public boolean isWhiteSpaceChunk() {
        return TextChunkUtils.isWhiteSpaceChunk(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TextChunk that = (TextChunk)o;
        return Double.compare(that.fontWeight, this.fontWeight) == 0 && Double.compare(that.italicAngle, this.italicAngle) == 0 && Objects.equals(this.value, that.value) && Objects.equals(this.fontName, that.fontName) && Arrays.equals(this.fontColor, that.fontColor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.fontWeight, this.italicAngle);
        return result;
    }

    public String toString() {
        return "TextChunk{text='" + this.value + '\'' + ", fontName='" + this.fontName + '\'' + ", fontSize=" + this.fontSize + ", fontWeight=" + this.fontWeight + ", italicAngle=" + this.italicAngle + ", baseLine=" + this.baseLine + ", fontColor=" + Arrays.toString(this.fontColor) + '}';
    }
}

