/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.sa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.gf.model.impl.sa.GFSANode;
import org.verapdf.gf.model.impl.sa.GFSARoot;
import org.verapdf.gf.model.impl.sa.GFSAStructElem;
import org.verapdf.gf.model.impl.sa.structelems.GFSAFactory;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.salayer.SAStructElem;
import org.verapdf.model.salayer.SAStructTreeRoot;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.PDStructTreeRoot;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.ITree;

public class GFSAStructTreeRoot
extends GenericModelObject
implements SAStructTreeRoot,
ITree {
    public static final String STRUCT_TREE_ROOT_TYPE = "SAStructTreeRoot";
    public static final String CHILDREN = "children";
    protected List<GFSAStructElem> children = null;
    private final INode node;
    private final PDStructTreeRoot treeRoot;

    public GFSAStructTreeRoot(PDStructTreeRoot treeRoot) {
        super(STRUCT_TREE_ROOT_TYPE);
        this.treeRoot = treeRoot;
        this.node = new GFSARoot(this);
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "children": {
                return this.getChildren();
            }
        }
        return super.getLinkedObjects(link);
    }

    public List<SAStructElem> getChildren() {
        if (this.children == null) {
            this.parseChildren();
        }
        return Collections.unmodifiableList(this.children);
    }

    protected void parseChildren() {
        List elements = this.treeRoot.getStructChildren();
        this.children = new ArrayList<GFSAStructElem>(elements.size());
        if (!elements.isEmpty()) {
            for (PDStructElem element : elements) {
                GFSAStructElem structElem = GFSAFactory.createTypedStructElem(element, "");
                GFSANode childNode = new GFSANode(structElem);
                structElem.setNode((INode)childNode);
                this.node.addChild((INode)childNode);
                this.children.add(structElem);
            }
        }
    }

    public INode getRoot() {
        return this.node;
    }
}

