/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.factory.chunks.CurveChunk;
import org.verapdf.gf.model.factory.chunks.GraphicsState;
import org.verapdf.gf.model.factory.chunks.LineArtContainer;
import org.verapdf.gf.model.factory.chunks.Matrix;
import org.verapdf.gf.model.factory.chunks.Path;
import org.verapdf.gf.model.factory.chunks.Rectangle;
import org.verapdf.gf.model.impl.containers.StaticStorages;
import org.verapdf.gf.model.impl.sa.GFSAXForm;
import org.verapdf.gf.model.impl.sa.util.ResourceHandler;
import org.verapdf.operator.Operator;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceCMYK;
import org.verapdf.pd.colors.PDDeviceGray;
import org.verapdf.pd.colors.PDDeviceRGB;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.images.PDXForm;
import org.verapdf.pd.images.PDXObject;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.Vertex;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

class ChunkParser {
    private static final Logger LOGGER = Logger.getLogger(ChunkParser.class.getName());
    private final Deque<GraphicsState> graphicsStateStack = new ArrayDeque<GraphicsState>();
    private final Stack<Long> markedContentStack = new Stack();
    private final Integer pageNumber;
    private final COSKey objectKey;
    private Matrix textMatrix = null;
    private Matrix textLineMatrix = null;
    private final GraphicsState graphicsState;
    private final Path path = new Path();
    private final List<IChunk> artifacts = new LinkedList<IChunk>();
    private List<Object> nonDrawingArtifacts = new LinkedList<Object>();
    private final LineArtContainer lineArtContainer = new LineArtContainer();

    public ChunkParser(Integer pageNumber, COSKey objectKey, GraphicsState inheritedGraphicState, ResourceHandler resourceHandler, double[] cropBox, Long markedContent) {
        this.pageNumber = pageNumber;
        this.objectKey = objectKey;
        this.graphicsState = inheritedGraphicState == null ? new GraphicsState(resourceHandler) : inheritedGraphicState.clone();
        this.graphicsState.getCTM().translate(-cropBox[0], -cropBox[1]);
        if (markedContent != null) {
            this.markedContentStack.push(markedContent);
        }
    }

    public List<IChunk> getArtifacts() {
        return this.artifacts;
    }

    public void parseChunk(Operator rawOperator, ResourceHandler resourceHandler, List<COSBase> arguments) {
        String operatorName;
        switch (operatorName = rawOperator.getOperator()) {
            case "BMC": {
                this.markedContentStack.push(this.getMCID(arguments, resourceHandler));
                break;
            }
            case "BDC": {
                this.markedContentStack.push(this.getMCID(arguments, resourceHandler));
                break;
            }
            case "EMC": {
                this.markedContentStack.pop();
                break;
            }
            case "g": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                ChunkParser.processColorSpace(this.graphicsState, resourceHandler, (PDColorSpace)PDDeviceGray.INSTANCE, ASAtom.DEVICEGRAY, false);
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace())) {
                    Double fillColor = this.getValueOfLastNumber(arguments);
                    if (fillColor == null) break;
                    this.graphicsState.setFillColor(new double[]{fillColor});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "rg": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                ChunkParser.processColorSpace(this.graphicsState, resourceHandler, (PDColorSpace)PDDeviceRGB.INSTANCE, ASAtom.DEVICERGB, false);
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace())) {
                    if (arguments.size() != 3 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber()) break;
                    this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal()});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "k": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                ChunkParser.processColorSpace(this.graphicsState, resourceHandler, (PDColorSpace)PDDeviceCMYK.INSTANCE, ASAtom.DEVICECMYK, false);
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace())) {
                    if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                    this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal(), arguments.get(3).getReal()});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "scn": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace())) {
                    if (arguments.size() == 1 || arguments.size() == 2) {
                        if (!arguments.get(0).getType().isNumber()) break;
                        this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal()});
                        break;
                    }
                    if (arguments.size() == 3 || arguments.size() == 4 && !arguments.get(3).getType().isNumber()) {
                        if (!arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber()) break;
                        this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal()});
                        break;
                    }
                    if (arguments.size() != 4 && arguments.size() != 5 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                    this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal(), arguments.get(3).getReal()});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "sc": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace())) {
                    if (arguments.size() == 1) {
                        if (!arguments.get(0).getType().isNumber()) break;
                        this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal()});
                        break;
                    }
                    if (arguments.size() == 3) {
                        if (!arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber()) break;
                        this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal()});
                        break;
                    }
                    if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                    this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal(), arguments.get(3).getReal()});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "cs": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                this.graphicsState.setFillColorSpace(resourceHandler.getColorSpace(ChunkParser.getLastCOSName(arguments)));
                break;
            }
            case "ET": {
                this.textMatrix = null;
                this.textLineMatrix = null;
                break;
            }
            case "BT": {
                this.textMatrix = new Matrix();
                this.textLineMatrix = new Matrix();
                break;
            }
            case "Td": {
                if (arguments.size() <= 1 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber()) break;
                this.processTd(arguments.get(0).getReal(), arguments.get(1).getReal());
                break;
            }
            case "TD": {
                if (arguments.size() <= 1 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber()) break;
                this.processTD(arguments.get(0).getReal(), arguments.get(1).getReal());
                break;
            }
            case "Tm": {
                this.textMatrix = new Matrix(arguments);
                this.textLineMatrix = this.textMatrix.clone();
                break;
            }
            case "T*": {
                this.processT_STAR();
                break;
            }
            case "Tj": {
                TextChunk textChunk = this.createTextChunk(arguments, "Tj");
                if (textChunk == null) break;
                this.putChunk(this.getMarkedContent(), (IChunk)textChunk);
                break;
            }
            case "TJ": {
                TextChunk textChunk = this.createTextChunk(arguments, "TJ");
                if (textChunk == null) break;
                this.putChunk(this.getMarkedContent(), (IChunk)textChunk);
                break;
            }
            case "'": {
                this.processT_STAR();
                TextChunk textChunk = this.createTextChunk(arguments, "'");
                if (textChunk == null) break;
                this.putChunk(this.getMarkedContent(), (IChunk)textChunk);
                break;
            }
            case "\"": {
                TextChunk textChunk;
                if (arguments.size() > 1 && arguments.get(0).getType().isNumber() && arguments.get(1).getType().isNumber()) {
                    this.processDoubleQuote(arguments.get(0).getReal(), arguments.get(1).getReal());
                }
                if ((textChunk = this.createTextChunk(arguments, "\"")) == null) break;
                this.putChunk(this.getMarkedContent(), (IChunk)textChunk);
                break;
            }
            case "Tz": {
                Double horizontalScaling = this.getValueOfLastNumber(arguments);
                if (horizontalScaling == null) break;
                this.graphicsState.getTextState().setHorizontalScaling(horizontalScaling / 100.0);
                break;
            }
            case "Tf": {
                COSBase textFontSize;
                this.graphicsState.getTextState().setTextFont(resourceHandler.getFont(ChunkParser.getFirstCOSName(arguments)));
                if (arguments.size() <= 1 || !(textFontSize = arguments.get(1)).getType().isNumber()) break;
                this.graphicsState.getTextState().setTextFontSize(textFontSize.getReal());
                break;
            }
            case "Tc": {
                Double characterSpacing = this.getValueOfLastNumber(arguments);
                if (characterSpacing == null) break;
                this.graphicsState.getTextState().setCharacterSpacing(characterSpacing);
                break;
            }
            case "Tw": {
                Double wordSpacing = this.getValueOfLastNumber(arguments);
                if (wordSpacing == null) break;
                this.graphicsState.getTextState().setWordSpacing(wordSpacing);
                break;
            }
            case "TL": {
                Double textLeading = this.getValueOfLastNumber(arguments);
                if (textLeading == null) break;
                this.graphicsState.getTextState().setTextLeading(textLeading);
                break;
            }
            case "Ts": {
                Double textRise = this.getValueOfLastNumber(arguments);
                if (textRise == null) break;
                this.graphicsState.getTextState().setTextRise(textRise);
                break;
            }
            case "BI": {
                this.putChunk(this.getMarkedContent(), (IChunk)new ImageChunk(this.parseImageBoundingBox()));
                break;
            }
            case "c": {
                if (arguments.size() != 6 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber() || !arguments.get(4).getType().isNumber() || !arguments.get(5).getType().isNumber()) break;
                CurveChunk curve = new CurveChunk(this.pageNumber, new Vertex(this.path.getCurrentX(), this.path.getCurrentY()), new Vertex(arguments.get(0).getReal().doubleValue(), arguments.get(1).getReal().doubleValue()), new Vertex(arguments.get(2).getReal().doubleValue(), arguments.get(3).getReal().doubleValue()), new Vertex(arguments.get(4).getReal().doubleValue(), arguments.get(5).getReal().doubleValue()));
                this.path.setCurrentPoint(curve.getX3(), curve.getY3());
                this.nonDrawingArtifacts.add((Object)curve);
                break;
            }
            case "h": {
                this.processh();
                break;
            }
            case "f": 
            case "F": 
            case "f*": {
                this.processh();
                this.processf();
                break;
            }
            case "l": {
                if (arguments.size() != 2 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber()) break;
                double x = arguments.get(0).getReal();
                double y = arguments.get(1).getReal();
                if (!NodeUtils.areCloseNumbers((double)this.path.getCurrentX(), (double)x) || !NodeUtils.areCloseNumbers((double)this.path.getCurrentY(), (double)y)) {
                    this.nonDrawingArtifacts.add(new LineChunk(this.pageNumber, this.path.getCurrentX(), this.path.getCurrentY(), x, y, this.graphicsState.getLineWidth()));
                }
                this.path.setCurrentPoint(x, y);
                break;
            }
            case "m": {
                if (arguments.size() != 2 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber()) break;
                double x = arguments.get(0).getReal();
                double y = arguments.get(1).getReal();
                this.path.setStartPoint(x, y);
                this.path.setCurrentPoint(x, y);
                break;
            }
            case "w": {
                double width;
                if (arguments.size() != 1 || !arguments.get(0).getType().isNumber() || !((width = arguments.get(0).getReal().doubleValue()) > 0.0)) break;
                this.graphicsState.setLineWidth(width);
                break;
            }
            case "J": {
                if (arguments.size() != 1 || arguments.get(0).getType() != COSObjType.COS_INTEGER) break;
                this.graphicsState.setLineCap(arguments.get(0).getInteger().intValue());
                break;
            }
            case "re": {
                if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                double x = arguments.get(0).getReal();
                double y = arguments.get(1).getReal();
                this.nonDrawingArtifacts.add(new Rectangle(this.pageNumber, x, y, arguments.get(2).getReal(), arguments.get(3).getReal()));
                this.path.setCurrentPoint(x, y);
                this.path.setStartPoint(x, y);
                break;
            }
            case "v": {
                if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                CurveChunk curve = new CurveChunk(this.pageNumber, new Vertex(this.path.getCurrentX(), this.path.getCurrentY()), new Vertex(arguments.get(0).getReal().doubleValue(), arguments.get(1).getReal().doubleValue()), new Vertex(arguments.get(2).getReal().doubleValue(), arguments.get(3).getReal().doubleValue()), true);
                this.path.setCurrentPoint(curve.getX3(), curve.getY3());
                this.nonDrawingArtifacts.add((Object)curve);
                break;
            }
            case "y": {
                if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                CurveChunk curve = new CurveChunk(this.pageNumber, new Vertex(this.path.getCurrentX(), this.path.getCurrentY()), new Vertex(arguments.get(0).getReal().doubleValue(), arguments.get(1).getReal().doubleValue()), new Vertex(arguments.get(2).getReal().doubleValue(), arguments.get(3).getReal().doubleValue()), false);
                this.path.setCurrentPoint(curve.getX3(), curve.getY3());
                this.nonDrawingArtifacts.add((Object)curve);
                break;
            }
            case "b": {
                this.processh();
                this.processB();
                break;
            }
            case "B": {
                this.processB();
                break;
            }
            case "b*": {
                this.processh();
                this.processB();
                break;
            }
            case "B*": {
                this.processB();
                break;
            }
            case "n": {
                this.nonDrawingArtifacts = new LinkedList<Object>();
                break;
            }
            case "s": {
                this.processh();
                this.processS();
                break;
            }
            case "S": {
                this.processS();
                break;
            }
            case "cm": {
                this.graphicsState.getCTM().concatenate(new Matrix(arguments));
                break;
            }
            case "Q": {
                if (this.graphicsStateStack.isEmpty()) break;
                this.graphicsState.copyProperties(this.graphicsStateStack.pop());
                break;
            }
            case "q": {
                this.graphicsStateStack.push(this.graphicsState.clone());
                break;
            }
            case "Do": {
                PDXObject xObject = resourceHandler.getXObject(ChunkParser.getLastCOSName(arguments));
                if (xObject == null) break;
                if (ASAtom.IMAGE.equals((Object)xObject.getType())) {
                    this.putChunk(this.getMarkedContent(), (IChunk)new ImageChunk(this.parseImageBoundingBox()));
                    break;
                }
                if (!ASAtom.FORM.equals((Object)xObject.getType())) break;
                GFSAXForm xForm = new GFSAXForm((PDXForm)xObject, resourceHandler, this.graphicsState, this.pageNumber, null, this.getMarkedContent());
                this.artifacts.addAll(xForm.getArtifacts());
                break;
            }
            case "d1": {
                this.graphicsState.disableColorOperators();
                break;
            }
        }
    }

    private static COSName getFirstCOSName(List<COSBase> arguments) {
        COSBase lastElement;
        COSBase cOSBase = lastElement = arguments.isEmpty() ? null : arguments.get(0);
        if (lastElement instanceof COSName) {
            return (COSName)lastElement;
        }
        return null;
    }

    private static COSName getLastCOSName(List<COSBase> arguments) {
        COSBase lastElement;
        COSBase cOSBase = lastElement = arguments.isEmpty() ? null : arguments.get(arguments.size() - 1);
        if (lastElement instanceof COSName) {
            return (COSName)lastElement;
        }
        return null;
    }

    private void processT_STAR() {
        this.processTD(0.0, -this.graphicsState.getTextState().getTextLeading());
    }

    private void processTD(double op1, double op2) {
        this.graphicsState.getTextState().setTextLeading(-op2);
        this.processTd(op1, op2);
    }

    private void processTd(double op1, double op2) {
        if (this.textLineMatrix != null) {
            this.textLineMatrix.concatenate(Matrix.getTranslateInstance(op1, op2));
            this.textMatrix = this.textLineMatrix.clone();
        } else {
            LOGGER.log(Level.WARNING, "Text operator not inside text content");
        }
    }

    private void processDoubleQuote(double op1, double op2) {
        this.graphicsState.getTextState().setWordSpacing(op1);
        this.graphicsState.getTextState().setCharacterSpacing(op2);
    }

    private void processh() {
        if (!NodeUtils.areCloseNumbers((double)this.path.getStartX(), (double)this.path.getCurrentX()) || !NodeUtils.areCloseNumbers((double)this.path.getStartY(), (double)this.path.getCurrentY())) {
            this.nonDrawingArtifacts.add(new LineChunk(this.pageNumber, this.path.getCurrentX(), this.path.getCurrentY(), this.path.getStartX(), this.path.getStartY(), this.graphicsState.getLineWidth()));
        }
        this.path.setCurrentPoint(this.path.getStartX(), this.path.getStartY());
    }

    private void processB() {
        ArrayList<LineChunk> artifacts = new ArrayList<LineChunk>(this.nonDrawingArtifacts.size());
        Long mcid = this.getMarkedContent();
        for (Object chunk : this.nonDrawingArtifacts) {
            LineChunk line;
            if (chunk instanceof LineChunk) {
                artifacts.add(this.transformLineChunk((LineChunk)chunk, this.graphicsState.getLineWidth(), this.graphicsState.getLineCap()));
                continue;
            }
            if (chunk instanceof CurveChunk) {
                this.lineArtContainer.add(mcid, CurveChunk.transformCurve((CurveChunk)((Object)chunk), this.graphicsState.getCTM()).getBoundingBox());
                continue;
            }
            if (!(chunk instanceof Rectangle) || (line = ((Rectangle)chunk).getLine(this.graphicsState.getLineWidth())) == null) continue;
            artifacts.add(this.transformLineChunk(line, line.getWidth(), LineChunk.PROJECTING_SQUARE_CAP_STYLE));
        }
        artifacts.forEach(artifact -> this.lineArtContainer.add(mcid, artifact.getBoundingBox()));
        this.artifacts.addAll(artifacts);
        this.nonDrawingArtifacts = new LinkedList<Object>();
    }

    private void processS() {
        ArrayList<LineChunk> artifacts = new ArrayList<LineChunk>(this.nonDrawingArtifacts.size());
        Long mcid = this.getMarkedContent();
        for (Object chunk : this.nonDrawingArtifacts) {
            if (chunk instanceof LineChunk) {
                artifacts.add(this.transformLineChunk((LineChunk)chunk, this.graphicsState.getLineWidth(), this.graphicsState.getLineCap()));
                continue;
            }
            if (chunk instanceof CurveChunk) {
                this.lineArtContainer.add(mcid, CurveChunk.transformCurve((CurveChunk)((Object)chunk), this.graphicsState.getCTM()).getBoundingBox());
                continue;
            }
            if (!(chunk instanceof Rectangle)) continue;
            Rectangle rectangle = (Rectangle)chunk;
            if (rectangle.getHeight() < this.graphicsState.getLineWidth() || rectangle.getWidth() < this.graphicsState.getLineWidth()) {
                LineChunk line = rectangle.getLine(this.graphicsState.getLineWidth());
                if (line == null) continue;
                artifacts.add(this.transformLineChunk(line, line.getWidth(), LineChunk.PROJECTING_SQUARE_CAP_STYLE));
                continue;
            }
            List<LineChunk> lines = rectangle.getLines(this.graphicsState.getLineWidth());
            for (LineChunk line : lines) {
                artifacts.add(this.transformLineChunk(line, this.graphicsState.getLineWidth(), LineChunk.PROJECTING_SQUARE_CAP_STYLE));
            }
        }
        artifacts.forEach(artifact -> this.lineArtContainer.add(mcid, artifact.getBoundingBox()));
        this.artifacts.addAll(artifacts);
        this.nonDrawingArtifacts = new LinkedList<Object>();
    }

    private void processf() {
        ArrayList<LineChunk> artifacts = new ArrayList<LineChunk>(this.nonDrawingArtifacts.size());
        Long mcid = this.getMarkedContent();
        for (int i = 0; i < this.nonDrawingArtifacts.size(); ++i) {
            LineChunk line;
            Object chunk = this.nonDrawingArtifacts.get(i);
            if (chunk instanceof Rectangle) {
                line = ((Rectangle)chunk).getLine(0.0);
                if (line == null) continue;
                artifacts.add(this.transformLineChunk(line, line.getWidth(), LineChunk.PROJECTING_SQUARE_CAP_STYLE));
                continue;
            }
            if (chunk instanceof LineChunk) {
                line = this.parsingRectangleFromLines(i);
                if (line != null) {
                    artifacts.add(line);
                    i += 3;
                    continue;
                }
                this.lineArtContainer.add(mcid, this.transformLineChunk((LineChunk)chunk, this.graphicsState.getLineWidth(), this.graphicsState.getLineCap()).getBoundingBox());
                continue;
            }
            if (!(chunk instanceof CurveChunk)) continue;
            this.lineArtContainer.add(mcid, CurveChunk.transformCurve((CurveChunk)((Object)chunk), this.graphicsState.getCTM()).getBoundingBox());
        }
        artifacts.forEach(artifact -> this.lineArtContainer.add(mcid, artifact.getBoundingBox()));
        this.artifacts.addAll(artifacts);
        this.nonDrawingArtifacts = new LinkedList<Object>();
    }

    private LineChunk parsingRectangleFromLines(int i) {
        LineChunk line1 = (LineChunk)this.nonDrawingArtifacts.get(i);
        if (i < this.nonDrawingArtifacts.size() - 3 && this.nonDrawingArtifacts.get(i + 1) instanceof LineChunk && this.nonDrawingArtifacts.get(i + 2) instanceof LineChunk && this.nonDrawingArtifacts.get(i + 3) instanceof LineChunk) {
            LineChunk line2 = (LineChunk)this.nonDrawingArtifacts.get(i + 1);
            LineChunk line3 = (LineChunk)this.nonDrawingArtifacts.get(i + 2);
            LineChunk line4 = (LineChunk)this.nonDrawingArtifacts.get(i + 3);
            if (Vertex.areCloseVertexes((Vertex)line1.getEnd(), (Vertex)line2.getStart()) && Vertex.areCloseVertexes((Vertex)line2.getEnd(), (Vertex)line3.getStart()) && Vertex.areCloseVertexes((Vertex)line3.getEnd(), (Vertex)line4.getStart()) && Vertex.areCloseVertexes((Vertex)line4.getEnd(), (Vertex)line1.getStart())) {
                if (line1.isHorizontalLine() && line2.isVerticalLine() && line3.isHorizontalLine() && line4.isVerticalLine()) {
                    LineChunk line = new LineChunk(this.pageNumber, line2.getCenterX(), line2.getCenterY(), line4.getCenterX(), line4.getCenterY(), Math.abs(line1.getCenterY() - line3.getCenterY()));
                    return this.transformLineChunk(line, line.getWidth(), LineChunk.BUTT_CAP_STYLE);
                }
                if (line1.isVerticalLine() && line2.isHorizontalLine() && line3.isVerticalLine() && line4.isHorizontalLine()) {
                    LineChunk line = new LineChunk(this.pageNumber, line1.getCenterX(), line1.getCenterY(), line3.getCenterX(), line3.getCenterY(), Math.abs(line2.getCenterY() - line4.getCenterY()));
                    return this.transformLineChunk(line, line.getWidth(), LineChunk.BUTT_CAP_STYLE);
                }
            }
        }
        return null;
    }

    private Double getValueOfLastNumber(List<COSBase> arguments) {
        COSBase base;
        if (!arguments.isEmpty() && (base = arguments.get(arguments.size() - 1)).getType().isNumber()) {
            return base.getReal();
        }
        return null;
    }

    private BoundingBox parseImageBoundingBox() {
        double y1;
        double x1;
        double x2 = x1 = this.graphicsState.getCTM().getTranslateX();
        if (this.graphicsState.getCTM().getScaleX() >= 0.0 && this.graphicsState.getCTM().getShearX() >= 0.0) {
            x2 += this.graphicsState.getCTM().getScaleX() + this.graphicsState.getCTM().getShearX();
        } else if (this.graphicsState.getCTM().getScaleX() < 0.0 && this.graphicsState.getCTM().getShearX() < 0.0) {
            x1 += this.graphicsState.getCTM().getScaleX() + this.graphicsState.getCTM().getShearX();
        } else if (this.graphicsState.getCTM().getScaleX() >= 0.0) {
            x1 += this.graphicsState.getCTM().getShearX();
            x2 += this.graphicsState.getCTM().getScaleX();
        } else {
            x1 += this.graphicsState.getCTM().getScaleX();
            x2 += this.graphicsState.getCTM().getShearX();
        }
        double y2 = y1 = this.graphicsState.getCTM().getTranslateY();
        if (this.graphicsState.getCTM().getScaleY() >= 0.0 && this.graphicsState.getCTM().getShearY() >= 0.0) {
            y2 += this.graphicsState.getCTM().getScaleY() + this.graphicsState.getCTM().getShearY();
        } else if (this.graphicsState.getCTM().getScaleY() < 0.0 && this.graphicsState.getCTM().getShearY() < 0.0) {
            y1 += this.graphicsState.getCTM().getScaleY() + this.graphicsState.getCTM().getShearY();
        } else if (this.graphicsState.getCTM().getScaleY() >= 0.0) {
            y1 += this.graphicsState.getCTM().getShearY();
            y2 += this.graphicsState.getCTM().getScaleY();
        } else {
            y1 += this.graphicsState.getCTM().getScaleY();
            y2 += this.graphicsState.getCTM().getShearY();
        }
        return new BoundingBox(this.pageNumber.intValue(), x1, y1, x2, y2);
    }

    private void putChunk(Long mcid, IChunk chunk) {
        if (chunk == null) {
            return;
        }
        if (mcid != null) {
            StaticStorages.getChunks().add(this.objectKey, mcid, chunk);
        } else {
            this.artifacts.add(chunk);
        }
    }

    private COSBase getArgument(List<COSBase> arguments, String operatorType) {
        if ("\"".equals(operatorType)) {
            if (arguments.size() > 2) {
                return arguments.get(2);
            }
        } else if (!arguments.isEmpty()) {
            return arguments.get(0);
        }
        return null;
    }

    private void parseTextShowArgument(COSBase argument, StringBuilder unicodeValue, Matrix textRenderingMatrix) {
        if (argument.getType() == COSObjType.COS_STRING) {
            textRenderingMatrix.concatenate(this.calculateTextRenderingMatrix());
            this.parseString((COSString)argument.getDirectBase(), unicodeValue);
        } else if (argument.getType() == COSObjType.COS_ARRAY) {
            boolean beforeFirstText = true;
            COSArray array = (COSArray)argument;
            for (COSObject obj : array) {
                if (obj == null) continue;
                if (obj.getType() == COSObjType.COS_STRING) {
                    if (beforeFirstText) {
                        beforeFirstText = false;
                        textRenderingMatrix.concatenate(this.calculateTextRenderingMatrix());
                    }
                    this.parseString((COSString)obj.getDirectBase(), unicodeValue);
                    continue;
                }
                if (!obj.getType().isNumber()) continue;
                this.textMatrix.concatenate(Matrix.getTranslateInstance(-obj.getReal().doubleValue() / 1000.0 * this.graphicsState.getTextState().getTextFontSize() * this.graphicsState.getTextState().getHorizontalScaling(), 0.0));
            }
        }
    }

    private void parseString(COSString string, StringBuilder unicodeValue) {
        byte[] bytes = string.get();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            while (((InputStream)inputStream).available() > 0) {
                int code = this.graphicsState.getTextState().getTextFont().readCode((InputStream)inputStream);
                unicodeValue.append(this.graphicsState.getTextState().getTextFont().toUnicode(code));
                Double width = this.graphicsState.getTextState().getTextFont().getWidth(code);
                if (width == null) {
                    LOGGER.log(Level.SEVERE, "Missing width of glyph with code " + code + " in font" + this.graphicsState.getTextState().getTextFont().getName());
                    width = 0.0;
                }
                this.textMatrix.concatenate(Matrix.getTranslateInstance((width * this.graphicsState.getTextState().getTextFontSize() / 1000.0 + this.graphicsState.getTextState().getCharacterSpacing() + (code == 32 ? this.graphicsState.getTextState().getWordSpacing() : 0.0)) * this.graphicsState.getTextState().getHorizontalScaling(), 0.0));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error processing text show operator's string argument : " + new String(bytes), e);
        }
    }

    private TextChunk createTextChunk(List<COSBase> arguments, String operatorType) {
        PDFont font = this.graphicsState.getTextState().getTextFont();
        COSBase argument = this.getArgument(arguments, operatorType);
        if (font != null && argument != null && (argument.getType() == COSObjType.COS_STRING || argument.getType() == COSObjType.COS_ARRAY) && this.textMatrix != null) {
            StringBuilder unicodeValue = new StringBuilder();
            Matrix textRenderingMatrixBefore = new Matrix();
            this.parseTextShowArgument(argument, unicodeValue, textRenderingMatrixBefore);
            Matrix textRenderingMatrixAfter = this.calculateTextRenderingMatrix();
            return new TextChunk(this.calculateTextBoundingBox(textRenderingMatrixBefore, textRenderingMatrixAfter, font.getBoundingBox()), unicodeValue.toString(), font.getNameWithoutSubset(), Math.sqrt(textRenderingMatrixAfter.getScaleY() * textRenderingMatrixAfter.getScaleY() + textRenderingMatrixAfter.getShearX() * textRenderingMatrixAfter.getShearX()), font.getFontWeight().doubleValue(), font.getFontDescriptor().getItalicAngle().doubleValue(), textRenderingMatrixAfter.getTranslateY(), this.graphicsState.getFillColor(), this.graphicsState.getFillColorSpace() != null ? this.graphicsState.getFillColorSpace().getType().getValue() : null);
        }
        return null;
    }

    private Matrix calculateTextRenderingMatrix() {
        Matrix parameters = new Matrix(this.graphicsState.getTextState().getTextFontSize() * this.graphicsState.getTextState().getHorizontalScaling(), 0.0, 0.0, this.graphicsState.getTextState().getTextFontSize(), 0.0, this.graphicsState.getTextState().getTextRise());
        return parameters.multiply(this.textMatrix).multiply(this.graphicsState.getCTM());
    }

    private BoundingBox calculateTextBoundingBox(Matrix textRenderingMatrixBefore, Matrix textRenderingMatrixAfter, double[] fontBoundingBox) {
        double y2;
        double y1;
        double x2;
        double x1;
        if (textRenderingMatrixBefore.getScaleX() >= 0.0 && textRenderingMatrixBefore.getShearX() >= 0.0) {
            x1 = textRenderingMatrixBefore.getTranslateX() + fontBoundingBox[1] * textRenderingMatrixBefore.getShearX() / 1000.0;
            x2 = textRenderingMatrixAfter.getTranslateX() + fontBoundingBox[3] * textRenderingMatrixAfter.getShearX() / 1000.0;
        } else if (textRenderingMatrixBefore.getScaleX() < 0.0 && textRenderingMatrixBefore.getShearX() < 0.0) {
            x1 = textRenderingMatrixAfter.getTranslateX() + fontBoundingBox[3] * textRenderingMatrixAfter.getShearX() / 1000.0;
            x2 = textRenderingMatrixBefore.getTranslateX() + fontBoundingBox[1] * textRenderingMatrixBefore.getShearX() / 1000.0;
        } else if (textRenderingMatrixBefore.getScaleX() >= 0.0) {
            x1 = textRenderingMatrixBefore.getTranslateX() + fontBoundingBox[3] * textRenderingMatrixBefore.getShearX() / 1000.0;
            x2 = textRenderingMatrixAfter.getTranslateX() + fontBoundingBox[1] * textRenderingMatrixAfter.getShearX() / 1000.0;
        } else {
            x1 = textRenderingMatrixAfter.getTranslateX() + fontBoundingBox[1] * textRenderingMatrixAfter.getShearX() / 1000.0;
            x2 = textRenderingMatrixBefore.getTranslateX() + fontBoundingBox[3] * textRenderingMatrixBefore.getShearX() / 1000.0;
        }
        if (textRenderingMatrixBefore.getScaleY() >= 0.0 && textRenderingMatrixBefore.getShearY() >= 0.0) {
            y1 = textRenderingMatrixBefore.getTranslateY() + fontBoundingBox[1] * textRenderingMatrixBefore.getScaleY() / 1000.0;
            y2 = textRenderingMatrixAfter.getTranslateY() + fontBoundingBox[3] * textRenderingMatrixAfter.getScaleY() / 1000.0;
        } else if (textRenderingMatrixBefore.getScaleY() < 0.0 && textRenderingMatrixBefore.getShearY() < 0.0) {
            y1 = textRenderingMatrixAfter.getTranslateY() + fontBoundingBox[3] * textRenderingMatrixAfter.getScaleY() / 1000.0;
            y2 = textRenderingMatrixBefore.getTranslateY() + fontBoundingBox[1] * textRenderingMatrixBefore.getScaleY() / 1000.0;
        } else if (textRenderingMatrixBefore.getScaleY() >= 0.0) {
            y1 = textRenderingMatrixAfter.getTranslateY() + fontBoundingBox[1] * textRenderingMatrixAfter.getScaleY() / 1000.0;
            y2 = textRenderingMatrixBefore.getTranslateY() + fontBoundingBox[3] * textRenderingMatrixBefore.getScaleY() / 1000.0;
        } else {
            y1 = textRenderingMatrixBefore.getTranslateY() + fontBoundingBox[3] * textRenderingMatrixBefore.getScaleY() / 1000.0;
            y2 = textRenderingMatrixAfter.getTranslateY() + fontBoundingBox[1] * textRenderingMatrixAfter.getScaleY() / 1000.0;
        }
        return new BoundingBox(this.pageNumber.intValue(), x1, y1, x2, y2);
    }

    private Long getMarkedContent() {
        if (!this.markedContentStack.empty()) {
            for (Long mcid : this.markedContentStack) {
                if (mcid == null) continue;
                return mcid;
            }
        }
        return null;
    }

    private Long getMCID(List<COSBase> arguments, ResourceHandler resources) {
        if (!arguments.isEmpty()) {
            COSBase cosProperties;
            PDResource properties;
            COSBase lastArg = arguments.get(arguments.size() - 1);
            if (lastArg.getType() == COSObjType.COS_DICT) {
                return lastArg.getIntegerKey(ASAtom.MCID);
            }
            if (lastArg.getType() == COSObjType.COS_NAME && resources != null && (properties = resources.getProperties(lastArg.getName())) != null && (cosProperties = properties.getObject().getDirectBase()) != null && cosProperties.getType() == COSObjType.COS_DICT) {
                return cosProperties.getIntegerKey(ASAtom.MCID);
            }
        }
        return null;
    }

    private LineChunk transformLineChunk(LineChunk lineChunk, double lineWidth, int lineCap) {
        return LineChunk.createLineChunk((Integer)this.pageNumber, (double)this.graphicsState.getCTM().transformX(lineChunk.getStartX(), lineChunk.getStartY()), (double)this.graphicsState.getCTM().transformY(lineChunk.getStartX(), lineChunk.getStartY()), (double)this.graphicsState.getCTM().transformX(lineChunk.getEndX(), lineChunk.getEndY()), (double)this.graphicsState.getCTM().transformY(lineChunk.getEndX(), lineChunk.getEndY()), (double)lineWidth, (int)lineCap);
    }

    private static void processColorSpace(GraphicsState graphicState, ResourceHandler resourcesHandler, PDColorSpace defaultCS, ASAtom name, boolean stroke) {
        PDColorSpace colorSpace = resourcesHandler.getColorSpace(name);
        if (colorSpace == null) {
            colorSpace = defaultCS;
        }
        if (!stroke) {
            graphicState.setFillColorSpace(colorSpace);
        }
    }

    private boolean isProcessColorSpace(PDColorSpace colorSpace) {
        if (colorSpace == null) {
            return false;
        }
        ASAtom colorSpaceType = colorSpace.getType();
        return ASAtom.DEVICERGB.equals((Object)colorSpaceType) || ASAtom.DEVICEGRAY.equals((Object)colorSpaceType) || ASAtom.DEVICECMYK.equals((Object)colorSpaceType) || ASAtom.ICCBASED.equals((Object)colorSpaceType) || ASAtom.CALRGB.equals((Object)colorSpaceType) || ASAtom.CALGRAY.equals((Object)colorSpaceType);
    }

    public void parseLineArts() {
        this.lineArtContainer.unionBoundingBoxes();
        for (Map.Entry<Long, List<BoundingBox>> boundingBoxes : this.lineArtContainer.entrySet()) {
            Long mcid = boundingBoxes.getKey();
            if (mcid == null) {
                for (BoundingBox box : boundingBoxes.getValue()) {
                    this.putChunk(mcid, (IChunk)new LineArtChunk(box));
                }
                continue;
            }
            MultiBoundingBox boundingBox = new MultiBoundingBox();
            for (BoundingBox box : boundingBoxes.getValue()) {
                boundingBox.union(box);
            }
            this.putChunk(mcid, (IChunk)new LineArtChunk((BoundingBox)boundingBox));
        }
    }
}

