/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import java.util.ArrayList;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.Vertex;

public class CurvesHelper {
    public static BoundingBox getBoundingBoxForCurveC(int pageNumber, Vertex v0, Vertex v1, Vertex v2, Vertex v3) {
        double[] x = CurvesHelper.getMinAndMaxCurveValues(v0.getX(), v1.getX(), v2.getX(), v3.getX());
        double[] y = CurvesHelper.getMinAndMaxCurveValues(v0.getY(), v1.getY(), v2.getY(), v3.getY());
        return new BoundingBox(pageNumber, x[0], y[0], x[1], y[1]);
    }

    public static BoundingBox getBoundingBoxForCurveY(int pageNumber, Vertex v0, Vertex v1, Vertex v3) {
        return CurvesHelper.getBoundingBoxForCurveV(pageNumber, v3, v1, v0);
    }

    public static BoundingBox getBoundingBoxForCurveV(int pageNumber, Vertex v0, Vertex v2, Vertex v3) {
        double x = CurvesHelper.getExtremumCurveValue(v0.getX(), v2.getX(), v3.getX());
        double y = CurvesHelper.getExtremumCurveValue(v0.getY(), v2.getY(), v3.getY());
        return new BoundingBox(pageNumber, Math.min(v0.getX(), x), Math.min(v0.getY(), y), Math.max(v0.getX(), x), Math.max(v0.getY(), y));
    }

    private static double[] getMinAndMaxCurveValues(double x0, double x1, double x2, double x3) {
        double[] solution;
        ArrayList<Double> values = new ArrayList<Double>(4);
        values.add(x0);
        values.add(x3);
        for (double t : solution = CurvesHelper.getQuadraticSolution(-x0 + 3.0 * x1 - 3.0 * x2 + x3, 2.0 * x0 - 4.0 * x1 + 2.0 * x2, x1 - x0)) {
            if (!(t > 0.0) || !(t < 1.0)) continue;
            values.add(CurvesHelper.getCurveValue(t, x0, x1, x2, x3));
        }
        values.sort(Double::compare);
        return new double[]{(Double)values.get(0), (Double)values.get(values.size() - 1)};
    }

    private static double[] getQuadraticSolution(double a, double b, double c) {
        double D = b * b - 4.0 * a * c;
        if (D < 0.0) {
            return new double[0];
        }
        if (D == 0.0) {
            return new double[]{-b / (2.0 * a)};
        }
        D = Math.sqrt(D);
        return new double[]{-(b + D) / (2.0 * a), -(b - D) / (2.0 * a)};
    }

    private static double getExtremumCurveValue(double x0, double x2, double x3) {
        double temp1 = 2.0 * (x0 - x2);
        double temp2 = 2.0 * x0 - 3.0 * x2 + x3;
        if (temp1 * temp2 < 0.0 || Math.abs(temp1) > Math.abs(temp2)) {
            return x3;
        }
        return CurvesHelper.getCurveValue(temp1 / temp2, x0, x0, x2, x3);
    }

    private static double getCurveValue(double t, double x0, double x1, double x2, double x3) {
        return (1.0 - t) * (1.0 - t) * (1.0 - t) * x0 + 3.0 * t * (1.0 - t) * (1.0 - t) * x1 + 3.0 * t * t * (1.0 - t) * x2 + t * t * t * x3;
    }
}

