/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.Vertex;

public class Matrix
implements Cloneable {
    private static final int SIZE = 6;
    private double[] matrixArray;

    public Matrix() {
        this.matrixArray = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    }

    private Matrix(double[] src) {
        this.matrixArray = src;
    }

    public Matrix(COSArray array) {
        this.matrixArray = new double[6];
        this.matrixArray[0] = array.at(0).getReal();
        this.matrixArray[1] = array.at(1).getReal();
        this.matrixArray[2] = array.at(2).getReal();
        this.matrixArray[3] = array.at(3).getReal();
        this.matrixArray[4] = array.at(4).getReal();
        this.matrixArray[5] = array.at(5).getReal();
    }

    public Matrix(List<COSBase> arguments) {
        this.matrixArray = new double[6];
        this.matrixArray[0] = arguments.get(0).getReal();
        this.matrixArray[1] = arguments.get(1).getReal();
        this.matrixArray[2] = arguments.get(2).getReal();
        this.matrixArray[3] = arguments.get(3).getReal();
        this.matrixArray[4] = arguments.get(4).getReal();
        this.matrixArray[5] = arguments.get(5).getReal();
    }

    public Matrix(double a, double b, double c, double d, double e, double f) {
        this.matrixArray = new double[6];
        this.matrixArray[0] = a;
        this.matrixArray[1] = b;
        this.matrixArray[2] = c;
        this.matrixArray[3] = d;
        this.matrixArray[4] = e;
        this.matrixArray[5] = f;
    }

    public double getValue(int row, int column) {
        return this.matrixArray[row * 2 + column];
    }

    public void concatenate(Matrix matrix) {
        this.matrixArray = this.checkDoubleValues(this.multiplyArrays(matrix.matrixArray, this.matrixArray));
    }

    public void translate(double tx, double ty) {
        this.matrixArray[4] = this.matrixArray[4] + (tx * this.matrixArray[0] + ty * this.matrixArray[2]);
        this.matrixArray[5] = this.matrixArray[5] + (tx * this.matrixArray[1] + ty * this.matrixArray[3]);
        this.checkDoubleValues(this.matrixArray);
    }

    public void scale(double sx, double sy) {
        this.matrixArray[0] = this.matrixArray[0] * sx;
        this.matrixArray[1] = this.matrixArray[1] * sx;
        this.matrixArray[2] = this.matrixArray[2] * sy;
        this.matrixArray[3] = this.matrixArray[3] * sy;
        this.checkDoubleValues(this.matrixArray);
    }

    public void rotate(double theta) {
        this.concatenate(Matrix.getRotateInstance(theta, 0.0, 0.0));
    }

    public Matrix multiply(Matrix other) {
        return new Matrix(this.checkDoubleValues(this.multiplyArrays(this.matrixArray, other.matrixArray)));
    }

    private double[] checkDoubleValues(double[] values) {
        if (!(Double.isFinite(values[0]) && Double.isFinite(values[1]) && Double.isFinite(values[2]) && Double.isFinite(values[3]) && Double.isFinite(values[4]) && Double.isFinite(values[5]))) {
            throw new IllegalArgumentException("Multiplication of two matrices gives invalid values");
        }
        return values;
    }

    private double[] multiplyArrays(double[] a, double[] b) {
        double[] c = new double[]{a[0] * b[0] + a[1] * b[2], a[0] * b[1] + a[1] * b[3], a[2] * b[0] + a[3] * b[2], a[2] * b[1] + a[3] * b[3], a[4] * b[0] + a[5] * b[2] + b[4], a[4] * b[1] + a[5] * b[3] + b[5]};
        return c;
    }

    public static Matrix getScaleInstance(double x, double y) {
        return new Matrix(x, 0.0, 0.0, y, 0.0, 0.0);
    }

    public static Matrix getTranslateInstance(double x, double y) {
        return new Matrix(1.0, 0.0, 0.0, 1.0, x, y);
    }

    public static Matrix getRotateInstance(double theta, double tx, double ty) {
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        return new Matrix(cosTheta, sinTheta, -sinTheta, cosTheta, tx, ty);
    }

    public static Matrix concatenate(Matrix a, Matrix b) {
        return b.multiply(a);
    }

    public Matrix clone() {
        return new Matrix((double[])this.matrixArray.clone());
    }

    public double getScaleX() {
        return this.matrixArray[0];
    }

    public double getShearY() {
        return this.matrixArray[1];
    }

    public double getShearX() {
        return this.matrixArray[2];
    }

    public double getScaleY() {
        return this.matrixArray[3];
    }

    public double getTranslateX() {
        return this.matrixArray[4];
    }

    public double getTranslateY() {
        return this.matrixArray[5];
    }

    public BoundingBox transformBoundingBox(BoundingBox boundingBox) {
        ArrayList<Double> xCoordinates = new ArrayList<Double>(4);
        ArrayList<Double> yCoordinates = new ArrayList<Double>(4);
        xCoordinates.add(this.transformX(boundingBox.getLeftX(), boundingBox.getBottomY()));
        xCoordinates.add(this.transformX(boundingBox.getRightX(), boundingBox.getBottomY()));
        xCoordinates.add(this.transformX(boundingBox.getLeftX(), boundingBox.getTopY()));
        xCoordinates.add(this.transformX(boundingBox.getRightX(), boundingBox.getTopY()));
        yCoordinates.add(this.transformY(boundingBox.getLeftX(), boundingBox.getBottomY()));
        yCoordinates.add(this.transformY(boundingBox.getRightX(), boundingBox.getBottomY()));
        yCoordinates.add(this.transformY(boundingBox.getLeftX(), boundingBox.getTopY()));
        yCoordinates.add(this.transformY(boundingBox.getRightX(), boundingBox.getTopY()));
        xCoordinates.sort(Double::compare);
        yCoordinates.sort(Double::compare);
        return new BoundingBox(boundingBox.getPageNumber().intValue(), ((Double)xCoordinates.get(0)).doubleValue(), ((Double)yCoordinates.get(0)).doubleValue(), ((Double)xCoordinates.get(3)).doubleValue(), ((Double)yCoordinates.get(3)).doubleValue());
    }

    public double transformX(double x, double y) {
        return x * this.getScaleX() + y * this.getShearY() + this.getTranslateX();
    }

    public double transformY(double x, double y) {
        return x * this.getShearX() + y * this.getScaleY() + this.getTranslateY();
    }

    public Vertex transformVertex(Vertex v) {
        return new Vertex(v.getPageNumber(), this.transformX(v.getX(), v.getY()), this.transformY(v.getX(), v.getY()));
    }

    public String toString() {
        return "[" + this.matrixArray[0] + "," + this.matrixArray[1] + "," + this.matrixArray[2] + "," + this.matrixArray[3] + "," + this.matrixArray[4] + "," + this.matrixArray[5] + "]";
    }

    public int hashCode() {
        return Arrays.hashCode(this.matrixArray);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals(this.matrixArray, ((Matrix)obj).matrixArray);
    }
}

