/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import org.verapdf.gf.model.factory.chunks.CurvesHelper;
import org.verapdf.gf.model.factory.chunks.Matrix;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.geometry.Vertex;

public class CurveChunk
extends InfoChunk {
    private final Vertex v0;
    private final Vertex v1;
    private final Vertex v2;
    private final Vertex v3;

    public CurveChunk(Integer pageNumber, Vertex v0, Vertex v1, Vertex v2, Vertex v3) {
        super(CurvesHelper.getBoundingBoxForCurveC(pageNumber, v0, v1, v2, v3));
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
    }

    public CurveChunk(Integer pageNumber, Vertex v0, Vertex v1, Vertex v2, boolean isVOperator) {
        this.v0 = v0;
        this.v3 = v2;
        if (isVOperator) {
            this.v1 = v0;
            this.v2 = v1;
            this.setBoundingBox(CurvesHelper.getBoundingBoxForCurveV(pageNumber, v0, v1, v2));
        } else {
            this.v1 = v1;
            this.v2 = v2;
            this.setBoundingBox(CurvesHelper.getBoundingBoxForCurveY(pageNumber, v0, v1, v2));
        }
    }

    public double getX3() {
        return this.v3.getX();
    }

    public double getY3() {
        return this.v3.getY();
    }

    public static CurveChunk transformCurve(CurveChunk curve, Matrix transformationMatrix) {
        return new CurveChunk(curve.getPageNumber(), transformationMatrix.transformVertex(curve.v0), transformationMatrix.transformVertex(curve.v1), transformationMatrix.transformVertex(curve.v2), transformationMatrix.transformVertex(curve.v3));
    }
}

