/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.sa;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.factory.chunks.ChunkFactory;
import org.verapdf.gf.model.factory.chunks.GraphicsState;
import org.verapdf.gf.model.impl.sa.util.ResourceHandler;
import org.verapdf.parser.PDFStreamParser;
import org.verapdf.pd.PDContentStream;
import org.verapdf.wcag.algorithms.entities.content.IChunk;

public class GFSAContentStream {
    private static final Logger LOGGER = Logger.getLogger(GFSAContentStream.class.getName());
    private final Integer pageNumber;
    private final COSKey objectKey;
    private List<IChunk> artifacts = null;
    private final ResourceHandler resourceHandler;
    private final GraphicsState inheritedGraphicsState;
    private final PDContentStream contentStream;
    private double[] cropBox;
    private final Long markedContent;

    public GFSAContentStream(PDContentStream contentStream, GraphicsState inheritedGraphicsState, ResourceHandler resourceHandler, Integer pageNumber, COSKey objectKey, double[] cropBox, Long markedContent) {
        this.pageNumber = pageNumber;
        this.objectKey = objectKey;
        this.contentStream = contentStream;
        this.resourceHandler = resourceHandler;
        this.inheritedGraphicsState = inheritedGraphicsState;
        this.markedContent = markedContent;
        this.cropBox = cropBox;
        if (this.cropBox == null) {
            this.cropBox = new double[]{0.0, 0.0, 0.0, 0.0};
        }
    }

    public List<IChunk> getArtifacts() {
        if (this.artifacts == null) {
            if (this.pageNumber != null) {
                this.parseChunks();
            } else {
                this.artifacts = Collections.emptyList();
            }
        }
        return this.artifacts;
    }

    protected void parseChunks() {
        block14: {
            if (this.contentStream != null) {
                try {
                    COSObject contentStream = this.contentStream.getContents();
                    if (contentStream.getType() != COSObjType.COS_STREAM && contentStream.getType() != COSObjType.COS_ARRAY) break block14;
                    try (ASInputStream opStream = contentStream.getDirectBase().getData(COSStream.FilterFlags.DECODE);
                         PDFStreamParser streamParser = new PDFStreamParser(opStream);){
                        streamParser.parseTokens();
                        this.artifacts = ChunkFactory.chunksFromTokens(this.pageNumber, this.objectKey, streamParser.getTokens(), this.inheritedGraphicsState, this.resourceHandler, this.cropBox, this.markedContent);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Error while parsing content stream. " + e.getMessage(), e);
                    this.artifacts = Collections.emptyList();
                }
            }
        }
    }
}

