/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.sa.util;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.images.PDXObject;

public class ResourceHandler {
    private final PDResources pageResources;
    private final PDResources objectResources;

    private ResourceHandler(PDResources pageResources) {
        this.pageResources = pageResources;
        this.objectResources = null;
    }

    private ResourceHandler(PDResources pageResources, PDResources objectResources) {
        this.pageResources = pageResources;
        this.objectResources = objectResources;
    }

    public static ResourceHandler getInstance(PDResources resources) {
        return new ResourceHandler(resources);
    }

    public static ResourceHandler getInstance(PDResources pageResources, PDResources objectResources) {
        return new ResourceHandler(pageResources, objectResources);
    }

    public PDColorSpace getColorSpace(COSName name) {
        if (name != null) {
            return this.getColorSpace(name.getName());
        }
        return null;
    }

    public PDColorSpace getColorSpace(ASAtom name) {
        PDColorSpace colorSpace = null;
        if (this.objectResources != null) {
            if (this.isDefaultColorSpaceUsed(name)) {
                colorSpace = this.objectResources.getDefaultColorSpace(name);
            } else {
                colorSpace = this.objectResources.getColorSpace(name);
                if (colorSpace == null && this.pageResources != null) {
                    colorSpace = this.pageResources.getColorSpace(name);
                }
            }
        } else if (this.pageResources != null) {
            colorSpace = this.isDefaultColorSpaceUsed(name) ? this.pageResources.getDefaultColorSpace(name) : this.pageResources.getColorSpace(name);
        }
        return colorSpace;
    }

    public PDFont getFont(COSName name) {
        if (name != null) {
            return this.getFont(name.getName());
        }
        return null;
    }

    public PDFont getFont(ASAtom name) {
        PDFont font = null;
        if (this.objectResources != null) {
            font = this.objectResources.getFont(name);
            if (font == null && this.pageResources != null) {
                font = this.pageResources.getFont(name);
            }
        } else if (this.pageResources != null) {
            font = this.pageResources.getFont(name);
        }
        return font;
    }

    public PDResource getProperties(ASAtom name) {
        PDResource res = null;
        if (this.objectResources != null) {
            res = this.objectResources.getProperties(name);
            if (res == null && this.pageResources != null) {
                res = this.pageResources.getProperties(name);
            }
        } else if (this.pageResources != null) {
            res = this.pageResources.getProperties(name);
        }
        return res;
    }

    public PDXObject getXObject(COSName name) {
        if (name != null) {
            return this.getXObject(name.getName());
        }
        return null;
    }

    public PDXObject getXObject(ASAtom name) {
        PDXObject xObject = null;
        if (this.objectResources != null) {
            xObject = this.objectResources.getXObject(name);
            if (xObject == null && this.pageResources != null) {
                xObject = this.pageResources.getXObject(name);
            }
        } else if (this.pageResources != null) {
            xObject = this.pageResources.getXObject(name);
        }
        return xObject;
    }

    private boolean isDefaultColorSpaceUsed(ASAtom name) {
        ASAtom value;
        return ResourceHandler.isDeviceDependent(name) && (this.objectResources != null ? (value = ColorSpaceFactory.getDefaultValue((PDResources)this.objectResources, (ASAtom)name)) != null : (value = ColorSpaceFactory.getDefaultValue((PDResources)this.pageResources, (ASAtom)name)) != null);
    }

    private static boolean isDeviceDependent(ASAtom name) {
        return ASAtom.DEVICERGB.equals((Object)name) || ASAtom.DEVICEGRAY.equals((Object)name) || ASAtom.DEVICECMYK.equals((Object)name);
    }

    public ResourceHandler getExtendedResources(PDResources objectResources) {
        return ResourceHandler.getInstance(this.pageResources, objectResources);
    }
}

