/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.AuditDuration;
import org.verapdf.component.AuditDurationImpl;
import org.verapdf.component.LogsSummary;
import org.verapdf.component.LogsSummaryImpl;
import org.verapdf.core.VeraPDFException;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.processor.AbstractBatchHandler;
import org.verapdf.processor.FeaturesNodeSerializer;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.VeraPDFExceptionSerializer;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.MetadataFixerReport;
import org.verapdf.processor.reports.Reports;
import org.verapdf.processor.reports.ValidationReport;
import org.verapdf.report.FeaturesNode;
import org.verapdf.report.FeaturesReport;

public class JsonHandler
extends AbstractBatchHandler {
    private final Writer writer;
    private final ObjectMapper objectMapper;
    private final boolean logPassed;
    private final Stack<Boolean> stack = new Stack();

    protected JsonHandler(Writer writer, boolean logPassed) {
        this.writer = writer;
        this.objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        this.logPassed = logPassed;
        SimpleModule module = new SimpleModule("FeaturesNodeSerializer", new Version(2, 1, 3, null, null, null));
        module.addSerializer(FeaturesNode.class, new FeaturesNodeSerializer(FeaturesNode.class));
        module.addSerializer(VeraPDFException.class, new VeraPDFExceptionSerializer(VeraPDFException.class));
        this.objectMapper.registerModule(module);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public void handleBatchStart(ProcessorConfig config) throws VeraPDFException {
        try {
            this.startDocument();
            this.startElement("report");
            this.addReleaseDetails();
            this.startElement("jobs", true);
            this.writer.flush();
        }
        catch (IOException excep) {
            throw new VeraPDFException(excep.getMessage(), excep);
        }
    }

    private void addReleaseDetails() throws VeraPDFException {
        this.startElement("buildInformation");
        this.startElement("releaseDetails", true);
        for (ReleaseDetails details : ReleaseDetails.getDetails()) {
            this.serializeElement(details, null);
        }
        this.endArray();
        this.endElement();
    }

    @Override
    public void handleBatchEnd(BatchSummary summary) throws VeraPDFException {
        try {
            this.endArray();
            this.serializeElement(summary, "batchSummary");
            this.endElement();
            this.endElement();
            this.writer.flush();
            this.close();
        }
        catch (IOException excep) {
            throw new VeraPDFException(excep.getMessage(), excep);
        }
    }

    @Override
    void resultStart(ProcessorResult result) throws VeraPDFException {
        this.startElement(null);
        this.serializeElement(result.getProcessedItem(), "itemDetails");
        try {
            this.writer.flush();
        }
        catch (IOException excep) {
            throw new VeraPDFException(excep.getMessage(), excep);
        }
    }

    @Override
    void parsingSuccess(TaskResult taskResult) throws VeraPDFException {
    }

    @Override
    void parsingFailure(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException");
    }

    @Override
    void pdfEncrypted(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException");
    }

    @Override
    void validationSuccess(TaskResult taskResult, List<ValidationResult> validationResults) throws VeraPDFException {
        LinkedList<ValidationReport> validationReports = new LinkedList<ValidationReport>();
        for (ValidationResult result : validationResults) {
            validationReports.add(Reports.createValidationReport(result, this.logPassed));
        }
        this.serializeElement(validationReports, "arlingtonResult");
    }

    @Override
    void validationFailure(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException");
    }

    @Override
    void featureSuccess(TaskResult taskResult, FeaturesReport featRep) throws VeraPDFException {
        this.serializeElement(featRep, "featuresReport");
    }

    @Override
    void featureFailure(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException");
    }

    @Override
    void fixerSuccess(TaskResult taskResult, MetadataFixerResult fixerResult) throws VeraPDFException {
        MetadataFixerReport mfRep = Reports.fromValues(fixerResult);
        this.serializeElement(mfRep, "fixerReport");
    }

    @Override
    void fixerFailure(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException");
    }

    @Override
    void resultEnd(ProcessorResult result, Boolean isLogsEnabled) throws VeraPDFException {
        LogsSummary logsSummary;
        AuditDuration duration = AuditDurationImpl.sumDuration(JsonHandler.getDurations(result));
        this.serializeElement(duration, "processingTime");
        if (isLogsEnabled.booleanValue() && (logsSummary = LogsSummaryImpl.getSummary()).getLogsCount() != 0) {
            this.serializeElement(logsSummary, "logs");
        }
        try {
            this.endElement();
            this.writer.flush();
        }
        catch (IOException excep) {
            throw new VeraPDFException(excep.getMessage(), excep);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private void startElement(String name) throws VeraPDFException {
        this.startElement(name, false);
    }

    private void startElement(String name, boolean isArray) throws VeraPDFException {
        try {
            if (this.stack.peek().booleanValue()) {
                this.writer.write(",");
            } else {
                this.stack.set(this.stack.size() - 1, true);
            }
            this.stack.add(false);
            if (name != null) {
                this.writer.write("\"");
                this.writer.write(name);
                this.writer.write("\":");
            }
            if (isArray) {
                this.writer.write("[");
            } else {
                this.writer.write("{");
            }
        }
        catch (IOException e) {
            throw new VeraPDFException(e.getMessage(), e);
        }
    }

    private void startDocument() throws VeraPDFException {
        this.stack.add(false);
        try {
            this.writer.write("{");
        }
        catch (IOException e) {
            throw new VeraPDFException(e.getMessage(), e);
        }
    }

    private void endElement() throws VeraPDFException {
        this.stack.pop();
        try {
            this.writer.write("}");
        }
        catch (IOException e) {
            throw new VeraPDFException(e.getMessage(), e);
        }
    }

    private void endArray() throws VeraPDFException {
        this.stack.pop();
        try {
            this.writer.write("]");
        }
        catch (IOException e) {
            throw new VeraPDFException(e.getMessage(), e);
        }
    }

    private void serializeElement(Object object, String name) throws VeraPDFException {
        try {
            if (this.stack.peek().booleanValue()) {
                this.writer.write(",");
            } else {
                this.stack.set(this.stack.size() - 1, true);
            }
            if (name != null) {
                this.writer.write("\"");
                this.writer.write(name);
                this.writer.write("\":");
            }
            this.writer.write(this.objectMapper.writeValueAsString(object));
        }
        catch (IOException e) {
            throw new VeraPDFException(e.getMessage(), e);
        }
    }
}

