/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.ma.zeno.ZenoSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class SharedAppendEvaluator
implements SequenceEvaluator {
    private Block.ChainAction[] actions;

    public SharedAppendEvaluator(Block expr) {
        this.actions = new Block.ChainAction[expr.size()];
        for (int i = 0; i < expr.size(); ++i) {
            Expression child = expr.getOperanda()[i].getChildExpression();
            if (child instanceof VariableReference) {
                SequenceEvaluator eval = child.makeElaborator().eagerly();
                this.actions[i] = (chain, context) -> chain.appendSequence(eval.evaluate(context).materialize());
                continue;
            }
            PullEvaluator pull = child.makeElaborator().elaborateForPull();
            this.actions[i] = (chain, context) -> {
                Item item;
                SequenceIterator iter = pull.iterate(context);
                while ((item = iter.next()) != null) {
                    chain = chain.append(item);
                }
                return chain;
            };
        }
    }

    @Override
    public Sequence evaluate(XPathContext context) throws XPathException {
        ZenoSequence chain = new ZenoSequence();
        for (Block.ChainAction action : this.actions) {
            chain = action.perform(chain, context);
        }
        return chain;
    }
}

