/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfFields;
import org.verapdf.gf.model.impl.arlington.GFAArrayOfXFA;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFAResource;
import org.verapdf.gf.model.impl.arlington.GFAStream;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AArrayOfFields;
import org.verapdf.model.alayer.AInteractiveForm;
import org.verapdf.model.alayer.AResource;

public class GFAInteractiveForm
extends GFAObject
implements AInteractiveForm {
    public GFAInteractiveForm(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AInteractiveForm");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "CO": {
                return this.getCO();
            }
            case "DR": {
                return this.getDR();
            }
            case "Fields": {
                return this.getFields();
            }
            case "XFA": {
                return this.getXFA();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AArrayOfFields> getCO() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getCO1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFields> getCO1_3() {
        COSObject object = this.getCOValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfFields> list = new ArrayList<GFAArrayOfFields>(1);
            list.add(new GFAArrayOfFields((COSArray)object.getDirectBase(), this.baseObject, "CO"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AResource> getDR() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_2: {
                return this.getDR1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AResource> getDR1_2() {
        COSObject object = this.getDRValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFAResource> list = new ArrayList<GFAResource>(1);
            list.add(new GFAResource((COSDictionary)object.getDirectBase(), this.baseObject, "DR"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFields> getFields() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_2: {
                return this.getFields1_2();
            }
        }
        return Collections.emptyList();
    }

    private List<AArrayOfFields> getFields1_2() {
        COSObject object = this.getFieldsValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfFields> list = new ArrayList<GFAArrayOfFields>(1);
            list.add(new GFAArrayOfFields((COSArray)object.getDirectBase(), this.baseObject, "Fields"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getXFA() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_5: {
                return this.getXFA1_5();
            }
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getXFA1_6();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getXFA1_5() {
        COSObject object = this.getXFAValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "XFA"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getXFA1_6() {
        COSObject object = this.getXFAValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFAArrayOfXFA> list = new ArrayList<GFAArrayOfXFA>(1);
            list.add(new GFAArrayOfXFA((COSArray)object.getDirectBase(), this.baseObject, "XFA"));
            return Collections.unmodifiableList(list);
        }
        if (object.getType() == COSObjType.COS_STREAM) {
            ArrayList<GFAStream> list = new ArrayList<GFAStream>(1);
            list.add(new GFAStream((COSStream)object.getDirectBase(), this.baseObject, "XFA"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsCO() {
        return this.baseObject.knownKey(ASAtom.getASAtom("CO"));
    }

    public COSObject getCOValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("CO"));
        return object;
    }

    @Override
    public String getCOType() {
        COSObject CO = this.getCOValue();
        return this.getObjectType(CO);
    }

    @Override
    public Boolean getCOHasTypeArray() {
        COSObject CO = this.getCOValue();
        return GFAInteractiveForm.getHasTypeArray(CO);
    }

    @Override
    public Boolean getcontainsDA() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DA"));
    }

    public COSObject getDAValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DA"));
        return object;
    }

    @Override
    public String getDAType() {
        COSObject DA = this.getDAValue();
        return this.getObjectType(DA);
    }

    @Override
    public Boolean getDAHasTypeStringByte() {
        COSObject DA = this.getDAValue();
        return GFAInteractiveForm.getHasTypeStringByte(DA);
    }

    @Override
    public Boolean getcontainsDR() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DR"));
    }

    public COSObject getDRValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DR"));
        return object;
    }

    @Override
    public String getDRType() {
        COSObject DR = this.getDRValue();
        return this.getObjectType(DR);
    }

    @Override
    public Boolean getDRHasTypeDictionary() {
        COSObject DR = this.getDRValue();
        return GFAInteractiveForm.getHasTypeDictionary(DR);
    }

    @Override
    public Boolean getcontainsFields() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Fields"));
    }

    public COSObject getFieldsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Fields"));
        return object;
    }

    @Override
    public String getFieldsType() {
        COSObject Fields = this.getFieldsValue();
        return this.getObjectType(Fields);
    }

    @Override
    public Boolean getFieldsHasTypeArray() {
        COSObject Fields = this.getFieldsValue();
        return GFAInteractiveForm.getHasTypeArray(Fields);
    }

    @Override
    public Boolean getcontainsNeedAppearances() {
        return this.baseObject.knownKey(ASAtom.getASAtom("NeedAppearances"));
    }

    public COSObject getNeedAppearancesDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: 
            case ARLINGTON1_2: {
                return COSBoolean.construct(false);
            }
        }
        return null;
    }

    public COSObject getNeedAppearancesValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("NeedAppearances"));
        if (object == null || object.empty()) {
            object = this.getNeedAppearancesDefaultValue();
        }
        return object;
    }

    @Override
    public String getNeedAppearancesType() {
        COSObject NeedAppearances = this.getNeedAppearancesValue();
        return this.getObjectType(NeedAppearances);
    }

    @Override
    public Boolean getNeedAppearancesHasTypeBoolean() {
        COSObject NeedAppearances = this.getNeedAppearancesValue();
        return GFAInteractiveForm.getHasTypeBoolean(NeedAppearances);
    }

    @Override
    public Boolean getcontainsQ() {
        return this.baseObject.knownKey(ASAtom.getASAtom("Q"));
    }

    public COSObject getQValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("Q"));
        return object;
    }

    @Override
    public String getQType() {
        COSObject Q = this.getQValue();
        return this.getObjectType(Q);
    }

    @Override
    public Boolean getQHasTypeInteger() {
        COSObject Q = this.getQValue();
        return GFAInteractiveForm.getHasTypeInteger(Q);
    }

    @Override
    public Long getQIntegerValue() {
        COSObject Q = this.getQValue();
        return GFAInteractiveForm.getIntegerValue(Q);
    }

    @Override
    public Boolean getcontainsSigFlags() {
        return this.baseObject.knownKey(ASAtom.getASAtom("SigFlags"));
    }

    public COSObject getSigFlagsDefaultValue() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return COSInteger.construct(0L);
            }
        }
        return null;
    }

    public COSObject getSigFlagsValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("SigFlags"));
        if (object == null || object.empty()) {
            object = this.getSigFlagsDefaultValue();
        }
        return object;
    }

    @Override
    public String getSigFlagsType() {
        COSObject SigFlags = this.getSigFlagsValue();
        return this.getObjectType(SigFlags);
    }

    @Override
    public Boolean getSigFlagsHasTypeBitmask() {
        COSObject SigFlags = this.getSigFlagsValue();
        return GFAInteractiveForm.getHasTypeBitmask(SigFlags);
    }

    @Override
    public Long getSigFlagsBitmaskValue() {
        COSObject SigFlags = this.getSigFlagsValue();
        return GFAInteractiveForm.getBitmaskValue(SigFlags);
    }

    @Override
    public Boolean getcontainsXFA() {
        return this.baseObject.knownKey(ASAtom.getASAtom("XFA"));
    }

    public COSObject getXFAValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("XFA"));
        return object;
    }

    @Override
    public Boolean getisXFAIndirect() {
        COSObject XFA = this.getXFAValue();
        return GFAInteractiveForm.getisIndirect(XFA);
    }

    @Override
    public String getXFAType() {
        COSObject XFA = this.getXFAValue();
        return this.getObjectType(XFA);
    }

    @Override
    public Boolean getXFAHasTypeArray() {
        COSObject XFA = this.getXFAValue();
        return GFAInteractiveForm.getHasTypeArray(XFA);
    }

    @Override
    public Boolean getXFAHasTypeStream() {
        COSObject XFA = this.getXFAValue();
        return GFAInteractiveForm.getHasTypeStream(XFA);
    }

    public COSObject getDRFontValue() {
        if (this.baseObject == null || !this.baseObject.getType().isDictionaryBased()) {
            return null;
        }
        COSObject DR = this.baseObject.getKey(ASAtom.getASAtom("DR"));
        if (DR == null || !DR.getType().isDictionaryBased()) {
            return null;
        }
        COSObject Font2 = DR.getKey(ASAtom.getASAtom("Font"));
        return Font2;
    }

    @Override
    public Boolean getcontainsDRFontAny() {
        COSObject DRFont = this.getDRFontValue();
        return DRFont != null && DRFont.getKeySet() != null && !DRFont.getKeySet().isEmpty();
    }
}

