/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.arlington;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.arlington.GFACalGrayColorSpace;
import org.verapdf.gf.model.impl.arlington.GFACalRGBColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAColorSpaceMapEntry;
import org.verapdf.gf.model.impl.arlington.GFADeviceNColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAICCBasedColorSpace;
import org.verapdf.gf.model.impl.arlington.GFAObject;
import org.verapdf.gf.model.impl.arlington.GFASeparationColorSpace;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.model.alayer.AColorSpaceMap;
import org.verapdf.model.alayer.AColorSpaceMapEntry;

public class GFAColorSpaceMap
extends GFAObject
implements AColorSpaceMap {
    public GFAColorSpaceMap(COSBase baseObject, COSBase parentObject, String keyName) {
        super(baseObject, parentObject, keyName, "AColorSpaceMap");
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Entries": {
                return this.getEntries();
            }
            case "DefaultCMYK": {
                return this.getDefaultCMYK();
            }
            case "DefaultGray": {
                return this.getDefaultGray();
            }
            case "DefaultRGB": {
                return this.getDefaultRGB();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AColorSpaceMapEntry> getEntries() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_0: {
                return this.getEntries1_0();
            }
            case ARLINGTON1_1: 
            case ARLINGTON1_2: {
                return this.getEntries1_1();
            }
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getEntries1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<AColorSpaceMapEntry> getEntries1_0() {
        LinkedList<GFAColorSpaceMapEntry> list = new LinkedList<GFAColorSpaceMapEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFAColorSpaceMapEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private List<AColorSpaceMapEntry> getEntries1_1() {
        LinkedList<GFAColorSpaceMapEntry> list = new LinkedList<GFAColorSpaceMapEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            if ("DefaultGray".equals(key.getValue()) || "DefaultRGB".equals(key.getValue())) continue;
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFAColorSpaceMapEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private List<AColorSpaceMapEntry> getEntries1_3() {
        LinkedList<GFAColorSpaceMapEntry> list = new LinkedList<GFAColorSpaceMapEntry>();
        for (ASAtom key : this.baseObject.getKeySet()) {
            if ("DefaultCMYK".equals(key.getValue()) || "DefaultGray".equals(key.getValue()) || "DefaultRGB".equals(key.getValue())) continue;
            COSObject object = this.baseObject.getKey(key);
            list.add(new GFAColorSpaceMapEntry(object != null ? object.get() : null, this.baseObject, this.parentObject, this.keyName, key.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    private List<org.verapdf.model.baselayer.Object> getDefaultCMYK() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDefaultCMYK1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDefaultCMYK1_3() {
        COSObject object = this.getDefaultCMYKValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            org.verapdf.model.baselayer.Object result = this.getDefaultCMYKArray1_3(object.getDirectBase(), "DefaultCMYK");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDefaultCMYKArray1_3(COSBase base, String keyName) {
        String subtypeValue;
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "DeviceN": {
                return new GFADeviceNColorSpace(base, this.baseObject, keyName);
            }
            case "ICCBased": {
                return new GFAICCBasedColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getDefaultGray() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: {
                return this.getDefaultGray1_1();
            }
            case ARLINGTON1_2: {
                return this.getDefaultGray1_2();
            }
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDefaultGray1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDefaultGray1_1() {
        COSObject object = this.getDefaultGrayValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFACalGrayColorSpace> list = new ArrayList<GFACalGrayColorSpace>(1);
            list.add(new GFACalGrayColorSpace((COSArray)object.getDirectBase(), this.baseObject, "DefaultGray"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDefaultGray1_2() {
        COSObject object = this.getDefaultGrayValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            org.verapdf.model.baselayer.Object result = this.getDefaultGrayArray1_2(object.getDirectBase(), "DefaultGray");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDefaultGrayArray1_2(COSBase base, String keyName) {
        String subtypeValue;
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CalGray": {
                return new GFACalGrayColorSpace(base, this.baseObject, keyName);
            }
            case "Separation": {
                return new GFASeparationColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getDefaultGray1_3() {
        COSObject object = this.getDefaultGrayValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            org.verapdf.model.baselayer.Object result = this.getDefaultGrayArray1_3(object.getDirectBase(), "DefaultGray");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDefaultGrayArray1_3(COSBase base, String keyName) {
        String subtypeValue;
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CalGray": {
                return new GFACalGrayColorSpace(base, this.baseObject, keyName);
            }
            case "DeviceN": {
                return new GFADeviceNColorSpace(base, this.baseObject, keyName);
            }
            case "ICCBased": {
                return new GFAICCBasedColorSpace(base, this.baseObject, keyName);
            }
            case "Separation": {
                return new GFASeparationColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getDefaultRGB() {
        switch (StaticContainers.getFlavour()) {
            case ARLINGTON1_1: 
            case ARLINGTON1_2: {
                return this.getDefaultRGB1_1();
            }
            case ARLINGTON1_3: 
            case ARLINGTON1_4: 
            case ARLINGTON1_5: 
            case ARLINGTON1_6: 
            case ARLINGTON1_7: 
            case ARLINGTON2_0: {
                return this.getDefaultRGB1_3();
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDefaultRGB1_1() {
        COSObject object = this.getDefaultRGBValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            ArrayList<GFACalRGBColorSpace> list = new ArrayList<GFACalRGBColorSpace>(1);
            list.add(new GFACalRGBColorSpace((COSArray)object.getDirectBase(), this.baseObject, "DefaultRGB"));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.baselayer.Object> getDefaultRGB1_3() {
        COSObject object = this.getDefaultRGBValue();
        if (object == null) {
            return Collections.emptyList();
        }
        if (object.getType() == COSObjType.COS_ARRAY) {
            org.verapdf.model.baselayer.Object result = this.getDefaultRGBArray1_3(object.getDirectBase(), "DefaultRGB");
            ArrayList<org.verapdf.model.baselayer.Object> list = new ArrayList<org.verapdf.model.baselayer.Object>(1);
            if (result != null) {
                list.add(result);
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private org.verapdf.model.baselayer.Object getDefaultRGBArray1_3(COSBase base, String keyName) {
        String subtypeValue;
        if (base.size() <= 0) {
            return null;
        }
        COSObject subtype = base.at(0);
        String string = subtypeValue = subtype != null ? subtype.getString() : null;
        if (subtypeValue == null) {
            return null;
        }
        switch (subtypeValue) {
            case "CalRGB": {
                return new GFACalRGBColorSpace(base, this.baseObject, keyName);
            }
            case "DeviceN": {
                return new GFADeviceNColorSpace(base, this.baseObject, keyName);
            }
            case "ICCBased": {
                return new GFAICCBasedColorSpace(base, this.baseObject, keyName);
            }
        }
        return null;
    }

    @Override
    public Boolean getcontainsDefaultCMYK() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DefaultCMYK"));
    }

    public COSObject getDefaultCMYKValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DefaultCMYK"));
        return object;
    }

    @Override
    public String getDefaultCMYKType() {
        COSObject DefaultCMYK = this.getDefaultCMYKValue();
        return this.getObjectType(DefaultCMYK);
    }

    @Override
    public Boolean getDefaultCMYKHasTypeArray() {
        COSObject DefaultCMYK = this.getDefaultCMYKValue();
        return GFAColorSpaceMap.getHasTypeArray(DefaultCMYK);
    }

    @Override
    public Boolean getcontainsDefaultGray() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DefaultGray"));
    }

    public COSObject getDefaultGrayValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DefaultGray"));
        return object;
    }

    @Override
    public String getDefaultGrayType() {
        COSObject DefaultGray = this.getDefaultGrayValue();
        return this.getObjectType(DefaultGray);
    }

    @Override
    public Boolean getDefaultGrayHasTypeArray() {
        COSObject DefaultGray = this.getDefaultGrayValue();
        return GFAColorSpaceMap.getHasTypeArray(DefaultGray);
    }

    @Override
    public Boolean getcontainsDefaultRGB() {
        return this.baseObject.knownKey(ASAtom.getASAtom("DefaultRGB"));
    }

    public COSObject getDefaultRGBValue() {
        COSObject object = this.baseObject.getKey(ASAtom.getASAtom("DefaultRGB"));
        return object;
    }

    @Override
    public String getDefaultRGBType() {
        COSObject DefaultRGB = this.getDefaultRGBValue();
        return this.getObjectType(DefaultRGB);
    }

    @Override
    public Boolean getDefaultRGBHasTypeArray() {
        COSObject DefaultRGB = this.getDefaultRGBValue();
        return GFAColorSpaceMap.getHasTypeArray(DefaultRGB);
    }
}

