/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.parser.PDFFlavour;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.structure.PDStructureNameSpace;
import org.verapdf.tools.TaggedPDFRoleMapHelper;
import org.verapdf.tools.resource.ASFileStreamCloser;

public class StaticResources {
    private static final Logger LOGGER = Logger.getLogger(StaticResources.class.getCanonicalName());
    private static final ThreadLocal<List<PDFFlavour>> flavour = new ThreadLocal();
    private static final ThreadLocal<PDDocument> document = new ThreadLocal();
    private static final ThreadLocal<TaggedPDFRoleMapHelper> roleMapHelper = new ThreadLocal();
    private static final ThreadLocal<Map<String, CMap>> cMapCache = new ThreadLocal();
    private static final ThreadLocal<Map<COSKey, PDStructureNameSpace>> structureNameSpaceCache = new ThreadLocal();
    private static final ThreadLocal<Map<String, FontProgram>> cachedFonts = new ThreadLocal();
    private static final ThreadLocal<Boolean> isFontProgramsParsing = new ThreadLocal();
    private static final ThreadLocal<String> password = new ThreadLocal();

    private StaticResources() {
    }

    public static void cacheCMap(String name, CMap cMap) {
        StaticResources.checkForNull(cMapCache);
        cMapCache.get().put(name, cMap);
    }

    public static PDDocument getDocument() {
        return document.get();
    }

    public static void setDocument(PDDocument document) {
        StaticResources.document.set(document);
    }

    public static CMap getCMap(String name) {
        StaticResources.checkForNull(cMapCache);
        return cMapCache.get().get(name);
    }

    public static void cacheStructureNameSpace(PDStructureNameSpace nameSpace) {
        StaticResources.checkForNull(structureNameSpaceCache);
        COSKey key = nameSpace.getObject().getObjectKey();
        structureNameSpaceCache.get().put(key, nameSpace);
    }

    public static PDStructureNameSpace getStructureNameSpace(COSKey key) {
        StaticResources.checkForNull(structureNameSpaceCache);
        return structureNameSpaceCache.get().get(key);
    }

    public static void cacheFontProgram(String key, FontProgram font) {
        StaticResources.checkForNull(cachedFonts);
        if (key != null) {
            cachedFonts.get().put(key, font);
        } else {
            cachedFonts.get().put(String.valueOf(font.hashCode()), font);
        }
    }

    public static FontProgram getCachedFont(String key) {
        StaticResources.checkForNull(cachedFonts);
        if (key == null) {
            return null;
        }
        return cachedFonts.get().get(key);
    }

    public static void clear() {
        StaticResources.checkForNull(cachedFonts);
        for (FontProgram fp : cachedFonts.get().values()) {
            ASFileStreamCloser fpr = fp.getFontProgramResource();
            if (fpr == null) continue;
            try {
                fpr.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Exception while closing font program", e);
            }
        }
        cMapCache.set(new HashMap());
        structureNameSpaceCache.set(new HashMap());
        cachedFonts.set(new HashMap());
        flavour.set(new LinkedList());
        document.set(null);
        isFontProgramsParsing.set(false);
        StaticResources.setPassword(null);
        roleMapHelper.set(null);
    }

    private static void checkForNull(ThreadLocal variable) {
        if (variable.get() == null) {
            variable.set(new HashMap());
        }
    }

    public static Map<String, CMap> getcMapCache() {
        return cMapCache.get();
    }

    public static void setcMapCache(Map<String, CMap> cMapCache) {
        StaticResources.cMapCache.set(cMapCache);
    }

    public static Map<COSKey, PDStructureNameSpace> getStructureNameSpaceCache() {
        return structureNameSpaceCache.get();
    }

    public static void setStructureNameSpaceCache(Map<COSKey, PDStructureNameSpace> structureNameSpaceCache) {
        StaticResources.structureNameSpaceCache.set(structureNameSpaceCache);
    }

    public static Map<String, FontProgram> getCachedFonts() {
        return cachedFonts.get();
    }

    public static void setCachedFonts(Map<String, FontProgram> cachedFonts) {
        StaticResources.cachedFonts.set(cachedFonts);
    }

    public static List<PDFFlavour> getFlavour() {
        return flavour.get();
    }

    public static void setFlavour(List<PDFFlavour> flavour) {
        StaticResources.flavour.set(flavour);
    }

    public static String getPassword() {
        return password.get();
    }

    public static void setPassword(String password) {
        StaticResources.password.set(password);
    }

    public static TaggedPDFRoleMapHelper getRoleMapHelper() {
        return roleMapHelper.get();
    }

    public static void setRoleMapHelper(Map<ASAtom, ASAtom> roleMap) {
        roleMapHelper.set(new TaggedPDFRoleMapHelper(roleMap));
    }

    public static void setRoleMapHelper(TaggedPDFRoleMapHelper roleMapHelper) {
        StaticResources.roleMapHelper.set(roleMapHelper);
    }

    public static void setIsFontProgramsParsing(Boolean isFontProgramsParsing) {
        StaticResources.isFontProgramsParsing.set(isFontProgramsParsing);
    }

    public static Boolean getIsFontProgramsParsing() {
        return isFontProgramsParsing.get();
    }
}

