/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools.xmp.validators;

import org.verapdf.model.tools.xmp.ValidatorsContainer;
import org.verapdf.xmp.impl.VeraPDFXMPNode;
import org.verapdf.xmp.options.PropertyOptions;

public class ArrayTypeValidator {
    private final ArrayTypeEnum type;
    private final ValidatorsContainer parentContainer;

    private ArrayTypeValidator(ArrayTypeEnum type, ValidatorsContainer parentContainer) {
        this.type = type;
        this.parentContainer = parentContainer;
    }

    public static ArrayTypeValidator fromValues(ArrayTypeEnum type, ValidatorsContainer parentContainer) {
        if (parentContainer == null) {
            throw new IllegalArgumentException("Argument parent container can not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument type can not be null");
        }
        return new ArrayTypeValidator(type, parentContainer);
    }

    public boolean isCorresponding(VeraPDFXMPNode node, String childType) {
        boolean isValidArrayType;
        if (node == null) {
            throw new IllegalArgumentException("Argument node can not be null");
        }
        if (childType == null) {
            throw new IllegalArgumentException("Argument child type can not be null");
        }
        PropertyOptions options = node.getOptions();
        switch (this.type) {
            case ALT: {
                isValidArrayType = options.isArrayAlternate();
                break;
            }
            case SEQ: {
                isValidArrayType = options.isArrayOrdered() && !options.isArrayAlternate();
                break;
            }
            case BAG: {
                isValidArrayType = options.isArray() && !options.isArrayOrdered() && !options.isArrayAlternate();
                break;
            }
            default: {
                throw new IllegalStateException("Array type validator must be created with valid type");
            }
        }
        if (!isValidArrayType) {
            return false;
        }
        for (VeraPDFXMPNode child : node.getChildren()) {
            if (this.parentContainer.validate(child, childType)) continue;
            return false;
        }
        return true;
    }

    public static enum ArrayTypeEnum {
        BAG("bag"),
        ALT("alt"),
        SEQ("seq");

        private final String type;

        private ArrayTypeEnum(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static ArrayTypeEnum fromString(String type) {
            if (type != null) {
                for (ArrayTypeEnum typeEnum : ArrayTypeEnum.values()) {
                    if (!type.equalsIgnoreCase(typeEnum.type)) continue;
                    return typeEnum;
                }
            }
            return null;
        }
    }
}

