/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.profiles.Rule;
import org.verapdf.pdfa.validation.profiles.RuleId;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.processor.reports.RuleSummary;
import org.verapdf.processor.reports.RuleSummaryImpl;
import org.verapdf.processor.reports.ValidationDetails;

final class ValidationDetailsImpl
implements ValidationDetails {
    private static final ValidationDetailsImpl defaultInstance = new ValidationDetailsImpl();
    @XmlAttribute
    private final int passedRules;
    @XmlAttribute
    private final int failedRules;
    @XmlAttribute
    private final int passedChecks;
    @XmlAttribute
    private final int failedChecks;
    private final Set<String> tags;
    @XmlElement(name="rule")
    private final Set<RuleSummary> ruleSummaries;

    private ValidationDetailsImpl() {
        this(0, 0, 0, 0, Collections.emptySet(), null);
    }

    private ValidationDetailsImpl(int passedRules, int failedRules, int passedChecks, int failedChecks, Set<RuleSummary> ruleSummaries, Set<String> tags) {
        this.passedRules = passedRules;
        this.failedRules = failedRules;
        this.passedChecks = passedChecks;
        this.failedChecks = failedChecks;
        this.ruleSummaries = new HashSet<RuleSummary>(ruleSummaries);
        this.tags = tags != null && !tags.isEmpty() ? tags : null;
    }

    @Override
    public int getPassedRules() {
        return this.passedRules;
    }

    @Override
    public int getFailedRules() {
        return this.failedRules;
    }

    @Override
    public int getPassedChecks() {
        return this.passedChecks;
    }

    @Override
    public int getFailedChecks() {
        return this.failedChecks;
    }

    @Override
    public Set<RuleSummary> getRuleSummaries() {
        return this.ruleSummaries;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    static final ValidationDetails defaultInstance() {
        return defaultInstance;
    }

    static ValidationDetails fromValues(ValidationResult result, boolean logPassedChecks) {
        ValidationProfile profile = result.getValidationProfile();
        Map<RuleId, List<TestAssertion>> assertionMap = ValidationDetailsImpl.mapAssertionsByRule(result.getTestAssertions());
        HashSet<RuleSummary> ruleSummaries = new HashSet<RuleSummary>();
        Map<RuleId, Integer> failedChecksMap = result.getFailedChecks();
        HashSet<String> tags = new HashSet<String>();
        int passedRules = 0;
        int failedRules = 0;
        int failedChecks = 0;
        for (Rule rule : profile.getRules()) {
            RuleSummary summary = assertionMap.containsKey(rule.getRuleId()) ? RuleSummaryImpl.fromValues(rule.getRuleId(), rule.getDescription(), rule.getObject(), rule.getTest(), assertionMap.get(rule.getRuleId()), logPassedChecks, failedChecksMap.get(rule.getRuleId()), rule.getTags()) : RuleSummaryImpl.uncheckedInstance(rule.getRuleId(), rule.getDescription(), rule.getObject(), rule.getTest(), rule.getTags());
            failedChecks += summary.getFailedChecks();
            Set<String> summaryTags = summary.getTags();
            if (summary.getRuleStatus() == TestAssertion.Status.PASSED) {
                ++passedRules;
                if (!logPassedChecks) continue;
                ruleSummaries.add(summary);
                if (summaryTags == null) continue;
                tags.addAll(summaryTags);
                continue;
            }
            ++failedRules;
            ruleSummaries.add(summary);
            if (summaryTags == null) continue;
            tags.addAll(summaryTags);
        }
        int passedChecks = result.getTotalAssertions() - failedChecks;
        return new ValidationDetailsImpl(passedRules, failedRules, passedChecks, failedChecks, ruleSummaries, tags);
    }

    private static Map<RuleId, List<TestAssertion>> mapAssertionsByRule(List<TestAssertion> assertions) {
        HashMap<RuleId, List<TestAssertion>> assertionMap = new HashMap<RuleId, List<TestAssertion>>();
        for (TestAssertion assertion : assertions) {
            if (assertionMap.containsKey(assertion.getRuleId())) {
                ((List)assertionMap.get(assertion.getRuleId())).add(assertion);
                continue;
            }
            ArrayList<TestAssertion> assertionSet = new ArrayList<TestAssertion>();
            assertionSet.add(assertion);
            assertionMap.put(assertion.getRuleId(), assertionSet);
        }
        return assertionMap;
    }

    static class Adapter
    extends XmlAdapter<ValidationDetailsImpl, ValidationDetails> {
        Adapter() {
        }

        public ValidationDetails unmarshal(ValidationDetailsImpl details) {
            return details;
        }

        public ValidationDetailsImpl marshal(ValidationDetails details) {
            return (ValidationDetailsImpl)details;
        }
    }
}

