/*
 * This file is part of VeraPDF Validation Model API for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * VeraPDF Validation Model API for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.xmplayer;
		
import org.verapdf.model.baselayer.Object;
import java.util.Set;

		
/**
* Extension schema definition from the XMP package
*/
public interface ExtensionSchemaDefinition extends ExtensionSchemaObject {
	



	/**
	* true if extension schema namespace URI (’pdfaSchema:namespaceURI’ property) is of type URI
	*/
	public Boolean getisNamespaceURIValidURI();

	/**
	* true if extension schema preferred prefix (’pdfaSchema:prefix’ property) is of type Text
	*/
	public Boolean getisPrefixValidText();

	/**
	* true if extension schema properties list (’pdfaSchema:property’ property) is of type Seq
	*/
	public Boolean getisPropertyValidSeq();

	/**
	* true if extension schema description (’pdfaSchema:schema’ property) is of type Text
	*/
	public Boolean getisSchemaValidText();

	/**
	* true if extension schema value types list (’pdfaSchema:valueType’ property) is of type Seq
	*/
	public Boolean getisValueTypeValidSeq();

	/**
	* namespace prefix for the extension schema namespace URI property
	*/
	public String getnamespaceURIPrefix();

	/**
	* namespace prefix for the extension schema prefix property
	*/
	public String getprefixPrefix();

	/**
	* namespace prefix for the extension schema properties list property
	*/
	public String getpropertyPrefix();

	/**
	* namespace prefix for the extension schema schema description property
	*/
	public String getschemaPrefix();

	/**
	* namespace prefix for the extension schema value type list property
	*/
	public String getvalueTypePrefix();
}
