/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public abstract class TextInfoChunk
extends InfoChunk {
    protected double fontSize = 0.0;
    protected double baseLine = Double.MAX_VALUE;
    protected double slantDegree = 0.0;
    protected boolean isHiddenText = false;

    public TextInfoChunk() {
    }

    public TextInfoChunk(BoundingBox bbox) {
        super(bbox);
    }

    public TextInfoChunk(BoundingBox bbox, double fontSize, double baseLine) {
        super(bbox);
        this.fontSize = fontSize;
        this.baseLine = baseLine;
    }

    public TextInfoChunk(BoundingBox bbox, double fontSize, double baseLine, double slantDegree) {
        this(bbox, fontSize, baseLine);
        this.slantDegree = slantDegree;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setBaseLine(double baseLine) {
        this.baseLine = baseLine;
    }

    public double getBaseLine() {
        return this.baseLine;
    }

    protected void add(TextInfoChunk chunk) {
        if (this.fontSize < chunk.getFontSize()) {
            this.fontSize = chunk.getFontSize();
        }
        if (this.isLeftRightHorizontalText() || this.isUpBottomVerticalText()) {
            if (chunk.getBaseLine() < this.baseLine) {
                this.baseLine = chunk.getBaseLine();
            }
        } else if (this.isRightLeftHorizontalText() || this.isBottomUpVerticalText()) {
            if (chunk.getBaseLine() > this.baseLine) {
                this.baseLine = chunk.getBaseLine();
            }
        } else if (chunk.getBaseLine() < this.baseLine) {
            this.baseLine = chunk.getBaseLine();
        }
        this.unionBoundingBox(chunk.getBoundingBox());
    }

    public double getSlantDegree() {
        return this.slantDegree;
    }

    public void setSlantDegree(double slantDegree) {
        this.slantDegree = slantDegree;
    }

    public double getTextStart() {
        if (this.isLeftRightHorizontalText()) {
            return this.getLeftX();
        }
        if (this.isRightLeftHorizontalText()) {
            return this.getRightX();
        }
        if (this.isBottomUpVerticalText()) {
            return this.getBottomY();
        }
        if (this.isUpBottomVerticalText()) {
            return this.getTopY();
        }
        return this.getLeftX();
    }

    public void setTextStart(double textStart) {
        if (this.isLeftRightHorizontalText()) {
            this.getBoundingBox().setLeftX(textStart);
        } else if (this.isRightLeftHorizontalText()) {
            this.getBoundingBox().setRightX(textStart);
        } else if (this.isBottomUpVerticalText()) {
            this.getBoundingBox().setBottomY(textStart);
        } else if (this.isUpBottomVerticalText()) {
            this.getBoundingBox().setTopY(textStart);
        } else {
            this.getBoundingBox().setLeftX(textStart);
        }
    }

    public boolean isHorizontalText() {
        return this.isLeftRightHorizontalText() || this.isRightLeftHorizontalText();
    }

    public boolean isRightLeftHorizontalText() {
        return NodeUtils.areCloseNumbers(180.0, Math.abs(this.slantDegree));
    }

    public boolean isLeftRightHorizontalText() {
        return NodeUtils.areCloseNumbers(0.0, Math.abs(this.slantDegree));
    }

    public boolean isVerticalText() {
        return NodeUtils.areCloseNumbers(90.0, Math.abs(this.slantDegree));
    }

    public boolean isBottomUpVerticalText() {
        return NodeUtils.areCloseNumbers(90.0, this.slantDegree);
    }

    public boolean isUpBottomVerticalText() {
        return NodeUtils.areCloseNumbers(-90.0, this.slantDegree);
    }

    public double getTextEnd() {
        if (this.isLeftRightHorizontalText()) {
            return this.getRightX();
        }
        if (this.isRightLeftHorizontalText()) {
            return this.getLeftX();
        }
        if (this.isBottomUpVerticalText()) {
            return this.getTopY();
        }
        if (this.isUpBottomVerticalText()) {
            return this.getBottomY();
        }
        return this.getRightX();
    }

    public void setTextEnd(double textEnd) {
        if (this.isLeftRightHorizontalText()) {
            this.getBoundingBox().setRightX(textEnd);
        } else if (this.isRightLeftHorizontalText()) {
            this.getBoundingBox().setLeftX(textEnd);
        } else if (this.isBottomUpVerticalText()) {
            this.getBoundingBox().setTopY(textEnd);
        } else if (this.isUpBottomVerticalText()) {
            this.getBoundingBox().setBottomY(textEnd);
        } else {
            this.getBoundingBox().setRightX(textEnd);
        }
    }

    public double getTextCenter() {
        if (this.isHorizontalText()) {
            return this.getCenterX();
        }
        if (this.isVerticalText()) {
            return this.getCenterY();
        }
        return this.getCenterX();
    }

    public String getValue() {
        return "";
    }

    public double getFirstBaseLine() {
        return this.getBaseLine();
    }

    public boolean isHiddenText() {
        return this.isHiddenText;
    }

    public void setHiddenText(boolean hiddenText) {
        this.isHiddenText = hiddenText;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TextInfoChunk that = (TextInfoChunk)o;
        return Double.compare(that.fontSize, this.fontSize) == 0 && Double.compare(that.baseLine, this.baseLine) == 0 && Double.compare(that.slantDegree, this.slantDegree) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.fontSize, this.baseLine);
        return result;
    }
}

