/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.TextAlignment;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;

public class TextBlock
extends TextInfoChunk {
    private final List<TextLine> textLines = new ArrayList<TextLine>();
    private boolean hasStartLine = false;
    private boolean hasEndLine = false;
    private TextAlignment textAlignment = null;

    public TextBlock() {
    }

    public TextBlock(BoundingBox bbox, double fontSize, double baseLine) {
        super(bbox, fontSize, baseLine);
        this.fontSize = fontSize;
        this.baseLine = baseLine;
    }

    public TextBlock(BoundingBox boundingBox) {
        super(boundingBox);
    }

    public TextBlock(TextLine line) {
        super(line.getBoundingBox(), line.getFontSize(), line.getBaseLine());
        this.textLines.add(line);
        this.setHiddenText(line.isHiddenText());
    }

    public TextBlock(TextBlock block) {
        super(block.getBoundingBox(), block.getFontSize(), block.getBaseLine());
        this.textLines.addAll(block.getLines());
        this.setHiddenText(block.isHiddenText());
    }

    public List<TextLine> getLines() {
        return this.textLines;
    }

    public TextLine getFirstLine() {
        if (this.textLines.isEmpty()) {
            return null;
        }
        return this.textLines.get(0);
    }

    public TextLine getLastLine() {
        if (this.textLines.isEmpty()) {
            return null;
        }
        return this.textLines.get(this.textLines.size() - 1);
    }

    public void setLastLine(TextLine lastLine) {
        if (!this.textLines.isEmpty()) {
            this.textLines.set(this.textLines.size() - 1, lastLine);
        } else {
            this.textLines.add(lastLine);
        }
    }

    public void setFirstLine(TextLine firstLine) {
        if (!this.textLines.isEmpty()) {
            this.textLines.set(0, firstLine);
        } else {
            this.textLines.add(firstLine);
        }
    }

    public TextLine getSecondLine() {
        if (this.textLines.size() > 1) {
            return this.textLines.get(1);
        }
        return null;
    }

    public TextLine getPenultLine() {
        if (this.textLines.size() > 1) {
            return this.textLines.get(this.textLines.size() - 2);
        }
        return null;
    }

    public void add(TextLine line) {
        this.textLines.add(line);
        super.add(line);
    }

    public void add(List<TextLine> lines) {
        for (TextLine line : lines) {
            this.add(line);
        }
    }

    public double getFirstLineIndent() {
        TextLine secondTextLine = this.getSecondLine();
        if (secondTextLine != null) {
            return this.getFirstLine().getLeftX() - secondTextLine.getLeftX();
        }
        return 0.0;
    }

    public int getLinesNumber() {
        return this.textLines.size();
    }

    public boolean isEmpty() {
        return this.textLines.isEmpty() || this.textLines.stream().allMatch(TextLine::isEmpty);
    }

    public String toString() {
        if (this.textLines.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder("");
        for (int i = 0; i < this.textLines.size() - 1; ++i) {
            String textString = this.textLines.get(i).getValue();
            result.append(textString);
            TextChunkUtils.formatLineEnd(result);
        }
        result.append(this.textLines.get(this.textLines.size() - 1).getValue());
        return result.toString();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.textLines.size();
        for (TextLine textLine : this.textLines) {
            result = 31 * result + textLine.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof TextBlock)) {
            return false;
        }
        TextBlock that = (TextBlock)o;
        return this.textLines.equals(that.getLines());
    }

    public TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public boolean isHasStartLine() {
        return this.hasStartLine;
    }

    public void setHasStartLine(boolean hasStartLine) {
        this.hasStartLine = hasStartLine;
    }

    public boolean isHasEndLine() {
        return this.hasEndLine;
    }

    public void setHasEndLine(boolean hasEndLine) {
        this.hasEndLine = hasEndLine;
    }
}

