/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.verapdf.cos.COSKey;
import org.verapdf.gf.model.impl.containers.StaticStorages;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

public class LineArtContainer {
    private final Map<Long, List<BoundingBox>> lineArtBBoxes = new HashMap<Long, List<BoundingBox>>();
    private final Map<Long, LineArtChunk> lineArts = new HashMap<Long, LineArtChunk>();
    private final Map<Long, List<LineChunk>> lineArtLines = new HashMap<Long, List<LineChunk>>();
    private final COSKey objectKey;

    public LineArtContainer(COSKey objectKey) {
        this.objectKey = objectKey;
    }

    public List<BoundingBox> getBoundingBoxes(Long mcid) {
        return this.lineArtBBoxes.get(mcid);
    }

    public List<LineChunk> getLineChunks(Long mcid) {
        return this.lineArtLines.get(mcid);
    }

    public LineArtChunk getLineArt(Long mcid) {
        return this.lineArts.get(mcid);
    }

    public void add(Long mcid, LineChunk lineChunk) {
        List<LineChunk> lineChunks = this.getLineChunks(mcid);
        if (lineChunks != null) {
            lineChunks.add(lineChunk);
        } else {
            lineChunks = new LinkedList<LineChunk>();
            lineChunks.add(lineChunk);
            this.lineArtLines.put(mcid, lineChunks);
        }
        this.add(mcid, lineChunk.getBoundingBox());
    }

    public void add(Long mcid, BoundingBox boundingBox) {
        List<BoundingBox> list = this.getBoundingBoxes(mcid);
        if (list != null) {
            boolean isSeparateBoundingBox = true;
            for (int i = 0; i < list.size(); ++i) {
                if (!boundingBox.overlaps(list.get(i))) continue;
                isSeparateBoundingBox = false;
                list.set(i, list.get(i).union(boundingBox));
                break;
            }
            if (isSeparateBoundingBox) {
                list.add(new BoundingBox(boundingBox));
            }
        } else {
            if (mcid != null) {
                LineArtChunk lineArtChunk = new LineArtChunk();
                StaticStorages.getChunks().add(this.objectKey, mcid, (IChunk)lineArtChunk);
                this.lineArts.put(mcid, lineArtChunk);
            }
            list = new ArrayList<BoundingBox>();
            list.add(new BoundingBox(boundingBox));
            this.lineArtBBoxes.put(mcid, list);
        }
    }

    public void unionBoundingBoxes() {
        for (List<BoundingBox> list : this.lineArtBBoxes.values()) {
            for (int i = list.size() - 2; i >= 0; --i) {
                BoundingBox box = list.get(i);
                int j = i + 1;
                while (j < list.size()) {
                    BoundingBox box2 = list.get(j);
                    if (box.overlaps(box2)) {
                        box.union(box2);
                        list.remove(j);
                        continue;
                    }
                    ++j;
                }
            }
        }
    }

    public Set<Map.Entry<Long, List<BoundingBox>>> entrySet() {
        return this.lineArtBBoxes.entrySet();
    }
}

